# coding: utf-8

"""
    Asteroid Agents API

    Version 1 of the Asteroid Agents API

    The version of the OpenAPI document: v1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Cookie(BaseModel):
    """
    Cookie
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the cookie")
    name: StrictStr = Field(description="Display name for the cookie")
    key: StrictStr = Field(description="The cookie name/key")
    value: StrictStr = Field(description="The cookie value")
    expiry: Optional[datetime] = Field(default=None, description="When the cookie expires (optional)")
    domain: StrictStr = Field(description="The domain for which the cookie is valid")
    secure: StrictBool = Field(description="Whether the cookie should only be sent over HTTPS")
    same_site: StrictStr = Field(description="SameSite attribute for the cookie")
    http_only: StrictBool = Field(description="Whether the cookie should be accessible only via HTTP(S)")
    created_at: datetime = Field(description="When the cookie was created")
    __properties: ClassVar[List[str]] = ["id", "name", "key", "value", "expiry", "domain", "secure", "same_site", "http_only", "created_at"]

    @field_validator('same_site')
    def same_site_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Strict', 'Lax', 'None']):
            raise ValueError("must be one of enum values ('Strict', 'Lax', 'None')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Cookie from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Cookie from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "key": obj.get("key"),
            "value": obj.get("value"),
            "expiry": obj.get("expiry"),
            "domain": obj.get("domain"),
            "secure": obj.get("secure"),
            "same_site": obj.get("same_site"),
            "http_only": obj.get("http_only"),
            "created_at": obj.get("created_at")
        })
        return _obj


