# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.job_cancellation_response import JobCancellationResponse
from ..types.job_status_response import JobStatusResponse
from .raw_client import AsyncRawJobsClient, RawJobsClient


class JobsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawJobsClient
        """
        return self._raw_client

    def get_job(self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> JobStatusResponse:
        """
        Check the status and retrieve results of an asynchronous job
        (e.g., submitted via `/extract_async`).

        Parameters
        ----------
        job_id : str
            Identifier returned from an async job submission (e.g., `/extract_async`).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        JobStatusResponse
            Current job status payload

        Examples
        --------
        from pulse import Pulse

        client = Pulse()
        client.jobs.get_job(
            job_id="jobId",
        )
        """
        _response = self._raw_client.get_job(job_id, request_options=request_options)
        return _response.data

    def cancel_job(
        self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> JobCancellationResponse:
        """
        Attempts to cancel an asynchronous job that is currently pending
        or processing. Jobs that have already completed will remain unchanged.

        Parameters
        ----------
        job_id : str
            Identifier returned from an async job submission (e.g., `/extract_async`).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        JobCancellationResponse
            Job cancellation accepted

        Examples
        --------
        from pulse import Pulse

        client = Pulse()
        client.jobs.cancel_job(
            job_id="jobId",
        )
        """
        _response = self._raw_client.cancel_job(job_id, request_options=request_options)
        return _response.data


class AsyncJobsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawJobsClient
        """
        return self._raw_client

    async def get_job(
        self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> JobStatusResponse:
        """
        Check the status and retrieve results of an asynchronous job
        (e.g., submitted via `/extract_async`).

        Parameters
        ----------
        job_id : str
            Identifier returned from an async job submission (e.g., `/extract_async`).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        JobStatusResponse
            Current job status payload

        Examples
        --------
        import asyncio

        from pulse import AsyncPulse

        client = AsyncPulse()


        async def main() -> None:
            await client.jobs.get_job(
                job_id="jobId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_job(job_id, request_options=request_options)
        return _response.data

    async def cancel_job(
        self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> JobCancellationResponse:
        """
        Attempts to cancel an asynchronous job that is currently pending
        or processing. Jobs that have already completed will remain unchanged.

        Parameters
        ----------
        job_id : str
            Identifier returned from an async job submission (e.g., `/extract_async`).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        JobCancellationResponse
            Job cancellation accepted

        Examples
        --------
        import asyncio

        from pulse import AsyncPulse

        client = AsyncPulse()


        async def main() -> None:
            await client.jobs.cancel_job(
                job_id="jobId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_job(job_id, request_options=request_options)
        return _response.data
