# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ExtractResponse(UncheckedBaseModel):
    """
    High-level structure returned by the synchronous extract API.
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Primary markdown content extracted from the document.
    """

    html: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional HTML representation when returnHtml is true.
    """

    job_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Identifier assigned to the extraction job.
    """

    warnings: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Non-fatal warnings generated during extraction.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(default=None)
    """
    Additional metadata supplied by the backend.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
