# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel
from vrt_lss_studio.models.cargo_rotation_type import CargoRotationType

class CargoCompatibilities(BaseModel):
    """
    Cargo [compatibilities](#section/Description/Compatibilities).   # noqa: E501
    """
    width: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Width in meters, used to check the transport box capacity.")
    height: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Height in meters, used to check the transport box capacity.")
    length: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Length in meters, used to check the transport box capacity.")
    rotation: Optional[Annotated[List[CargoRotationType], Field(min_length=0, max_length=4)]] = Field(default=None, description="List of possibilities of a object rotations (90 degree step):   * `ALL` - can rotate by any axis   * `YAW` - can yaw   * `PITCH` - can pitch   * `ROLL` - can roll  Empty list means object rotations is prohibited.  More about [cargo placement](#section/Description/Cargo-placement).")
    box_restrictions: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    cargo_features: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    cargo_restrictions: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    __properties = ["width", "height", "length", "rotation", "box_restrictions", "cargo_features", "cargo_restrictions"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CargoCompatibilities:
        """Create an instance of CargoCompatibilities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CargoCompatibilities:
        """Create an instance of CargoCompatibilities from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CargoCompatibilities.parse_obj(obj)

        _obj = CargoCompatibilities.parse_obj({
            "width": obj.get("width") if obj.get("width") is not None else 0,
            "height": obj.get("height") if obj.get("height") is not None else 0,
            "length": obj.get("length") if obj.get("length") is not None else 0,
            "rotation": obj.get("rotation"),
            "box_restrictions": obj.get("box_restrictions"),
            "cargo_features": obj.get("cargo_features"),
            "cargo_restrictions": obj.get("cargo_restrictions")
        })
        return _obj


