# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, field_validator

class DemandExtraDuration(BaseModel):
    """
    Additional time for the execution of the application by a certain performer.   # noqa: E501
    """
    demand_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(description="The key of the ticket whose events need to increase the execution time.")
    performer_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Performer's key.")
    additional_duration: Annotated[str, Field(min_length=3, strict=True, max_length=16)] = Field(description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    __properties = ["demand_key", "performer_key", "additional_duration"]

    @validator('additional_duration')
    def additional_duration_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DemandExtraDuration:
        """Create an instance of DemandExtraDuration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if demand_key (nullable) is None
        # and __fields_set__ contains the field
        if self.demand_key is None and "demand_key" in self.__fields_set__:
            _dict['demand_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DemandExtraDuration:
        """Create an instance of DemandExtraDuration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DemandExtraDuration.parse_obj(obj)

        _obj = DemandExtraDuration.parse_obj({
            "demand_key": obj.get("demand_key"),
            "performer_key": obj.get("performer_key"),
            "additional_duration": obj.get("additional_duration") if obj.get("additional_duration") is not None else 'PT0S'
        })
        return _obj


