# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel
from vrt_lss_studio.models.experiment import Experiment
from vrt_lss_studio.models.table_list_stats import TableListStats

class ExperimentList(BaseModel):
    """
    A list of experiments.  # noqa: E501
    """
    experiments: Annotated[List[Experiment], Field(min_length=0, max_length=101)] = Field(description="A list of experiments.")
    statistics: TableListStats
    __properties = ["experiments", "statistics"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExperimentList:
        """Create an instance of ExperimentList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in experiments (list)
        _items = []
        if self.experiments:
            for _item in self.experiments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['experiments'] = _items
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExperimentList:
        """Create an instance of ExperimentList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExperimentList.parse_obj(obj)

        _obj = ExperimentList.parse_obj({
            "experiments": [Experiment.from_dict(_item) for _item in obj.get("experiments")] if obj.get("experiments") is not None else None,
            "statistics": TableListStats.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None
        })
        return _obj


