# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel
from vrt_lss_studio.models.measurements import Measurements
from vrt_lss_studio.models.time_window import TimeWindow
from vrt_lss_studio.models.transport_load import TransportLoad

class StopStatistics(BaseModel):
    """
    Statistics for a specific stop during a trip.   # noqa: E501
    """
    location_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Location key for stop.")
    demand_ids: Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(min_length=0, max_length=15001)] = Field(description="Keys list of demands fulfilled at this stop.")
    stop_time_window: Optional[TimeWindow]
    measurements: Measurements
    upload: TransportLoad
    download: TransportLoad
    max_load: TransportLoad
    arrival_load: TransportLoad
    departure_load: TransportLoad
    __properties = ["location_key", "demand_ids", "stop_time_window", "measurements", "upload", "download", "max_load", "arrival_load", "departure_load"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StopStatistics:
        """Create an instance of StopStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of stop_time_window
        if self.stop_time_window:
            _dict['stop_time_window'] = self.stop_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of measurements
        if self.measurements:
            _dict['measurements'] = self.measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of upload
        if self.upload:
            _dict['upload'] = self.upload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of download
        if self.download:
            _dict['download'] = self.download.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max_load
        if self.max_load:
            _dict['max_load'] = self.max_load.to_dict()
        # override the default output from pydantic by calling `to_dict()` of arrival_load
        if self.arrival_load:
            _dict['arrival_load'] = self.arrival_load.to_dict()
        # override the default output from pydantic by calling `to_dict()` of departure_load
        if self.departure_load:
            _dict['departure_load'] = self.departure_load.to_dict()
        # set to None if stop_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.stop_time_window is None and "stop_time_window" in self.__fields_set__:
            _dict['stop_time_window'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StopStatistics:
        """Create an instance of StopStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StopStatistics.parse_obj(obj)

        _obj = StopStatistics.parse_obj({
            "location_key": obj.get("location_key"),
            "demand_ids": obj.get("demand_ids"),
            "stop_time_window": TimeWindow.from_dict(obj.get("stop_time_window")) if obj.get("stop_time_window") is not None else None,
            "measurements": Measurements.from_dict(obj.get("measurements")) if obj.get("measurements") is not None else None,
            "upload": TransportLoad.from_dict(obj.get("upload")) if obj.get("upload") is not None else None,
            "download": TransportLoad.from_dict(obj.get("download")) if obj.get("download") is not None else None,
            "max_load": TransportLoad.from_dict(obj.get("max_load")) if obj.get("max_load") is not None else None,
            "arrival_load": TransportLoad.from_dict(obj.get("arrival_load")) if obj.get("arrival_load") is not None else None,
            "departure_load": TransportLoad.from_dict(obj.get("departure_load")) if obj.get("departure_load") is not None else None
        })
        return _obj


