
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.account.email_verified import TypeAccountEmailVerified


if TYPE_CHECKING:
    from ...types.email_verification import TypeEmailVerification
    from ...types.email_verify_purpose import TypeEmailVerifyPurpose


class VerifyEmail(TLRequest[TypeAccountEmailVerified]):
    """
    Verify an email address.

    Raises:
        `400`EmailInvalidError: The specified email is invalid.
        `400`EmailNotAllowedError: The specified email cannot be used to complete the operation.
        `400`EmailVerifyExpiredError: The verification email has expired.
        `400`PhoneNumberInvalidError: The phone number is invalid.

    """

    _id = 0X32DA4CF
    _result_id = 0X51A41FC9

    def __init__(
        self,
        purpose: 'TypeEmailVerifyPurpose',
        verification: 'TypeEmailVerification'
    ):

        """
        Verify an email address.

        Args:
            purpose ('TypeEmailVerifyPurpose'): Verification purpose
            verification ('TypeEmailVerification'): Email verification code or token
        """

        self.purpose = purpose
        self.verification = verification

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcf\xa4-\x03' if boxed else b'') as writer:
            writer.object(
                self.purpose,
                group_id=0X41635250
            )
            writer.object(
                self.verification,
                group_id=0X4D88339D
            )

            return writer.getvalue()