
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.auth.sent_code import TypeAuthSentCode


if TYPE_CHECKING:
    from ...types.code_settings import TypeCodeSettings


class SendCode(TLRequest[TypeAuthSentCode]):
    """
    Send the verification code for login

    Raises:
        `400`ApiIdInvalidError: API ID invalid.
        `400`ApiIdPublishedFloodError: This API id was published somewhere, you can't use it now.
        `400`PhoneNumberAppSignupForbiddenError: You can't sign up using this app.
        `400`PhoneNumberBannedError: The provided phone number is banned from telegram.
        `400`PhoneNumberFloodError: You asked for the code too many times.
        `400`PhonePasswordProtectedError: This phone is password protected.
        `400`SmsCodeCreateFailedError: An error occurred while creating the SMS code.
        `500`AuthRestartError: Internal error (debug info {debug_info}), please repeat the method call.
        `500`AuthRestartError: Internal error (debug info {debug_info}), please repeat the method call.
        `406`PhoneNumberInvalidError: The phone number is invalid.
        `406`PhonePasswordFloodError: You have tried logging in too many times.
        `406`UpdateAppToLoginError: Please update to the latest version of MadelineProto to login.

    """

    _id = 0XA677244F
    _result_id = 0X8F0C24F5

    def __init__(
        self,
        phone_number: str,
        api_id: int,
        api_hash: str,
        settings: 'TypeCodeSettings'
    ):

        """
        Send the verification code for login

        Args:
            phone_number (str): Phone number in international format
            api_id (int): Application identifier (see [App configuration](https://core.telegram.org/myapp))
            api_hash (str): Application secret hash (see [App configuration](https://core.telegram.org/myapp))
            settings ('TypeCodeSettings'): Settings for the code type to send
        """

        self.phone_number = phone_number
        self.api_id = api_id
        self.api_hash = api_hash
        self.settings = settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'O$w\xa6' if boxed else b'') as writer:
            writer.string(self.phone_number)
            writer.int(self.api_id)
            writer.string(self.api_hash)
            writer.object(
                self.settings,
                group_id=0X4A76A298
            )

            return writer.getvalue()