
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.channels.admin_log_results import TypeChannelsAdminLogResults


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_channel import TypeInputChannel
    from ...types.channel_admin_log_events_filter import TypeChannelAdminLogEventsFilter


class GetAdminLog(TLRequest[TypeChannelsAdminLogResults]):
    """
    Get the admin log of a [channel/supergroup](https://core.telegram.org/api/channel)

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0X33DDF480
    _result_id = 0X116E3AC9

    def __init__(
        self,
        channel: 'TypeInputChannel',
        q: str,
        max_id: int,
        min_id: int,
        limit: int,
        events_filter: Optional['TypeChannelAdminLogEventsFilter'] = None,
        admins: Optional[List['TypeInputUser']] = None
    ):

        """
        Get the admin log of a [channel/supergroup](https://core.telegram.org/api/channel)

        Args:
            channel ('TypeInputChannel'): Channel
            q (str): Search query, can be empty
            max_id (int): Maximum ID of message to return (see [pagination](https://core.telegram.org/api/offsets))
            min_id (int): Minimum ID of message to return (see [pagination](https://core.telegram.org/api/offsets))
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            events_filter (Optional['TypeChannelAdminLogEventsFilter'], optional): Event filter
            admins (Optional[List['TypeInputUser']], optional): Only show events from these admins
        """

        self.channel = channel
        self.q = q
        self.max_id = max_id
        self.min_id = min_id
        self.limit = limit
        self.events_filter = events_filter
        self.admins = admins

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x80\xf4\xdd3' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )
                writer.string(self.q)

                if flags(self.events_filter, 0):
                    writer.object(
                        self.events_filter,
                        group_id=0X22E916DA
                    )

                if flags(self.admins, 1):
                    writer.vector(
                        self.admins,
                        lambda value: writer.object(
                            value,
                            group_id=0XB628962F
                        )
                    )
                writer.long(self.max_id)
                writer.long(self.min_id)
                writer.int(self.limit)

            return writer.getvalue()