
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser


class DeleteChatUser(TLRequest[TypeUpdates]):
    """
    Deletes a user from a chat and sends a service message on it.

    **Bots can use this method**

    Raises:
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`UserIdInvalidError: The provided user ID is invalid.
        `400`UserNotParticipantError: You're not a member of this supergroup/channel.

    """

    _id = 0XA2185CAB
    _result_id = 0XD68D29C0

    def __init__(
        self,
        chat_id: int,
        user_id: 'TypeInputUser',
        revoke_history: bool = False
    ):

        """
        Deletes a user from a chat and sends a service message on it.

        **Bots can use this method**

        Args:
            chat_id (int): Chat ID
            user_id ('TypeInputUser'): User ID to be deleted
            revoke_history (bool, optional): Remove the entire chat history of the specified user in this chat.
        """

        self.chat_id = chat_id
        self.user_id = user_id
        self.revoke_history = revoke_history

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xab\\\x18\xa2' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.revoke_history, 0)
                writer.long(self.chat_id)
                writer.object(
                    self.user_id,
                    group_id=0XB628962F
                )

            return writer.getvalue()