
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.high_scores import TypeMessagesHighScores


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_bot_inline_message_id import TypeInputBotInlineMessageID


class GetInlineGameHighScores(TLRequest[TypeMessagesHighScores]):
    """
    Get highscores of a game sent using an inline bot

    **Bots can use this method**

    Raises:
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`UserBotRequiredError: This method can only be called by a bot.

    """

    _id = 0XF635E1B
    _result_id = 0XAB759131

    def __init__(
        self,
        id: 'TypeInputBotInlineMessageID',
        user_id: 'TypeInputUser'
    ):

        """
        Get highscores of a game sent using an inline bot

        **Bots can use this method**

        Args:
            id ('TypeInputBotInlineMessageID'): ID of inline message
            user_id ('TypeInputUser'): Get high scores of a certain user
        """

        self.id = id
        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1b^c\x0f' if boxed else b'') as writer:
            writer.object(
                self.id,
                group_id=0XE8D574CF
            )
            writer.object(
                self.user_id,
                group_id=0XB628962F
            )

            return writer.getvalue()