
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.search_counter import TypeMessagesSearchCounter


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.messages_filter import TypeMessagesFilter


class GetSearchCounters(TLRequest[List[TypeMessagesSearchCounter]]):
    """
    Get the number of results that would be found by a [messages.search](https://core.telegram.org/method/messages.search) call with the same parameters

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X1BBCF300

    def __init__(
        self,
        peer: 'TypeInputPeer',
        filters: List['TypeMessagesFilter'],
        saved_peer_id: Optional['TypeInputPeer'] = None,
        top_msg_id: Optional[int] = None
    ):

        """
        Get the number of results that would be found by a [messages.search](https://core.telegram.org/method/messages.search) call with the same parameters

        Args:
            peer ('TypeInputPeer'): Peer where to search
            filters (List['TypeMessagesFilter']): Search filters
            saved_peer_id (Optional['TypeInputPeer'], optional): Search within the [saved message dialog](https://core.telegram.org/api/saved-messages) with this ID.
            top_msg_id (Optional[int], optional): If set, consider only messages within the specified [forum topic](https://core.telegram.org/api/forum#forum-topics)
        """

        self.peer = peer
        self.filters = filters
        self.saved_peer_id = saved_peer_id
        self.top_msg_id = top_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x00\xf3\xbc\x1b' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.saved_peer_id, 2):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0X995DB9DF
                    )

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)
                writer.vector(
                    self.filters,
                    lambda value: writer.object(
                        value,
                        group_id=0X8CDA33F
                    )
                )

            return writer.getvalue()