
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Int, Writer
from ...types.encrypted_chat import TypeEncryptedChat


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser


class RequestEncryption(TLRequest[TypeEncryptedChat]):
    """
    Sends a request to start a secret chat to the user.

    Raises:
        `400`DhGAInvalidError: g_a invalid.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`UserIdInvalidError: The provided user ID is invalid.

    """

    _id = 0XF64DAF43
    _result_id = 0X9E93492C

    def __init__(
        self,
        user_id: 'TypeInputUser',
        g_a: bytes,
        random_id: int = None
    ):

        """
        Sends a request to start a secret chat to the user.

        Args:
            user_id ('TypeInputUser'): User ID
            g_a (bytes): A = g ^ a mod p, see [Wikipedia](https://en.wikipedia.org/wiki/Diffie%E2%80%93Hellman_key_exchange)
            random_id (int, optional): Unique client request ID required to prevent resending. This also doubles as the chat ID.
        """

        self.user_id = user_id
        self.g_a = g_a
        self.random_id = Int() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'C\xafM\xf6' if boxed else b'') as writer:
            writer.object(
                self.user_id,
                group_id=0XB628962F
            )
            writer.int(self.random_id)
            writer.bytes(self.g_a)

            return writer.getvalue()