
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.web_view_result import TypeWebViewResult


if TYPE_CHECKING:
    from ...types.data_json import TypeDataJSON
    from ...types.input_user import TypeInputUser


class RequestSimpleWebView(TLRequest[TypeWebViewResult]):
    """
    Open a [bot mini app](https://core.telegram.org/api/bots/webapps).

    Raises:
        `400`BotInvalidError: This is not a valid bot.
        `400`UrlInvalidError: Invalid URL provided.

    """

    _id = 0X413A3E73
    _result_id = 0X60754D10

    def __init__(
        self,
        bot: 'TypeInputUser',
        platform: str,
        from_switch_webview: bool = False,
        from_side_menu: bool = False,
        compact: bool = False,
        fullscreen: bool = False,
        url: Optional[str] = None,
        start_param: Optional[str] = None,
        theme_params: Optional['TypeDataJSON'] = None
    ):

        """
        Open a [bot mini app](https://core.telegram.org/api/bots/webapps).

        Args:
            bot ('TypeInputUser'): Bot that owns the mini app
            platform (str): Short name of the application; 0-64 English letters, digits, and underscores
            from_switch_webview (bool, optional): Whether the webapp was opened by clicking on the switch_webview button shown on top of the inline results list returned by [messages.getInlineBotResults](https://core.telegram.org/method/messages.getInlineBotResults).
            from_side_menu (bool, optional): Set this flag if opening the Mini App from the installed [side menu entry](https://core.telegram.org/api/bots/attach).
            compact (bool, optional): Deprecated.
            fullscreen (bool, optional): Requests to open the app in fullscreen mode.
            url (Optional[str], optional): Web app URL, if opening from a keyboard button or inline result
            start_param (Optional[str], optional): Deprecated.
            theme_params (Optional['TypeDataJSON'], optional): [Theme parameters](https://core.telegram.org/api/bots/webapps#theme-parameters)
        """

        self.bot = bot
        self.platform = platform
        self.from_switch_webview = from_switch_webview
        self.from_side_menu = from_side_menu
        self.compact = compact
        self.fullscreen = fullscreen
        self.url = url
        self.start_param = start_param
        self.theme_params = theme_params

    def to_bytes(self, boxed: bool=True):
        with Writer(b's>:A' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.from_switch_webview, 1)
                flags(self.from_side_menu, 2)
                flags(self.compact, 7)
                flags(self.fullscreen, 8)
                writer.object(
                    self.bot,
                    group_id=0XB628962F
                )

                if flags(self.url, 3):
                    writer.string(self.url)

                if flags(self.start_param, 4):
                    writer.string(self.start_param)

                if flags(self.theme_params, 0):
                    writer.object(
                        self.theme_params,
                        group_id=0XE95B0798
                    )
                writer.string(self.platform)

            return writer.getvalue()