
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Long, Writer
from ...types.messages.sent_encrypted_message import TypeMessagesSentEncryptedMessage


if TYPE_CHECKING:
    from ...types.input_encrypted_chat import TypeInputEncryptedChat


class SendEncryptedService(TLRequest[TypeMessagesSentEncryptedMessage]):
    """
    Sends a service message to a secret chat.

    Raises:
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`DataInvalidError: Encrypted data invalid.
        `400`EncryptionDeclinedError: The secret chat was declined.
        `400`EncryptionIdInvalidError: The provided secret chat ID is invalid.
        `500`MsgWaitFailedError: A waiting call returned an error.
        `403`UserDeletedError: You can't send this secret message because the other participant deleted their account.
        `403`UserIsBlockedError: You were blocked by this user.

    """

    _id = 0X32D439A4
    _result_id = 0XFA58ED64

    def __init__(
        self,
        peer: 'TypeInputEncryptedChat',
        data: bytes,
        random_id: int = None
    ):

        """
        Sends a service message to a secret chat.

        Args:
            peer ('TypeInputEncryptedChat'): Secret chat ID
            data (bytes): TL-serialization of  [DecryptedMessage](https://core.telegram.org/type/DecryptedMessage) type, encrypted with a key generated during chat initialization
            random_id (int, optional): Unique client message ID required to prevent message resending
        """

        self.peer = peer
        self.data = data
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa49\xd42' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X947D3E78
            )
            writer.long(self.random_id)
            writer.bytes(self.data)

            return writer.getvalue()