
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.reaction import TypeReaction
    from ...types.input_peer import TypeInputPeer


class SendReaction(TLRequest[TypeUpdates]):
    """
    React to message.

    Raises:
        `403`AnonymousReactionsDisabledError: Sorry, anonymous administrators cannot leave reactions or participate in polls.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`PremiumAccountRequiredError: A premium account is required to execute this action.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`CustomReactionsTooManyError: Too many custom reactions were specified.
        `400`DocumentInvalidError: The specified document is invalid.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`MessageNotModifiedError: The provided message data is identical to the previous message data, the message wasn't modified.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`ReactionsTooManyError: The message already has exactly `reactions_uniq_max` reaction emojis, you can't react with a new emoji, see [the docs for more info &raquo;](https://core.telegram.org/api/config#client-configuration).
        `400`ReactionEmptyError: Empty reaction provided.
        `400`ReactionInvalidError: The specified reaction is invalid.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.

    """

    _id = 0XD30D78D4
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        msg_id: int,
        big: bool = False,
        add_to_recent: bool = False,
        reaction: Optional[List['TypeReaction']] = None
    ):

        """
        React to message.

        Args:
            peer ('TypeInputPeer'): Peer
            msg_id (int): Message ID to react to
            big (bool, optional): Whether a bigger and longer reaction should be shown
            add_to_recent (bool, optional): Whether to add this reaction to the [recent reactions list](https://core.telegram.org/api/reactions#recent-reactions).
            reaction (Optional[List['TypeReaction']], optional): A list of reactions
        """

        self.peer = peer
        self.msg_id = msg_id
        self.big = big
        self.add_to_recent = add_to_recent
        self.reaction = reaction

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd4x\r\xd3' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.big, 1)
                flags(self.add_to_recent, 2)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.msg_id)

                if flags(self.reaction, 0):
                    writer.vector(
                        self.reaction,
                        lambda value: writer.object(
                            value,
                            group_id=0X19F930D1
                        )
                    )

            return writer.getvalue()