
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.chat_reactions import TypeChatReactions


class SetChatAvailableReactions(TLRequest[TypeUpdates]):
    """
    Change the set of [message reactions](https://core.telegram.org/api/reactions) that can be used in a certain group, supergroup or channel

    Raises:
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatNotModifiedError: No changes were made to chat information because the new information you passed is identical to the current information.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X864B2581
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        available_reactions: 'TypeChatReactions',
        reactions_limit: Optional[int] = None,
        paid_enabled: bool = False
    ):

        """
        Change the set of [message reactions](https://core.telegram.org/api/reactions) that can be used in a certain group, supergroup or channel

        Args:
            peer ('TypeInputPeer'): Group where to apply changes
            available_reactions ('TypeChatReactions'): Allowed reaction emojis
            reactions_limit (Optional[int], optional): This flag may be used to impose a custom limit of unique reactions (i.e. a customizable version of [appConfig.reactions_uniq_max](https://core.telegram.org/api/config#reactions-uniq-max)); this field and the other info set by the method will then be available to users in [channelFull](https://core.telegram.org/constructor/channelFull) and [chatFull](https://core.telegram.org/constructor/chatFull). If this flag is not set, the previously configured reactions_limit will not be altered.
            paid_enabled (bool, optional): If this flag is set and a [Bool](https://core.telegram.org/type/Bool) is passed, the method will enable or disable [paid message reactions](https://core.telegram.org/api/reactions#paid-reactions). If this flag is not set, the previously stored setting will not be changed.
        """

        self.peer = peer
        self.available_reactions = available_reactions
        self.reactions_limit = reactions_limit
        self.paid_enabled = paid_enabled

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x81%K\x86' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.object(
                    self.available_reactions,
                    group_id=0XE0A5CEE3
                )

                if flags(self.reactions_limit, 0):
                    writer.int(self.reactions_limit)

                if flags(self.paid_enabled, 1):
                    writer.object(
                        self.paid_enabled,
                        group_id=0X43B904E1
                    )

            return writer.getvalue()