
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_wall_paper import TypeInputWallPaper
    from ...types.wall_paper_settings import TypeWallPaperSettings


class SetChatWallPaper(TLRequest[TypeUpdates]):
    """
    Set a custom [wallpaper](https://core.telegram.org/api/wallpapers) in a specific private chat with another user.

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`WallpaperInvalidError: The specified wallpaper is invalid.
        `400`WallpaperNotFoundError: The specified wallpaper could not be found.

    """

    _id = 0X8FFACAE1
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        for_both: bool = False,
        revert: bool = False,
        wallpaper: Optional['TypeInputWallPaper'] = None,
        settings: Optional['TypeWallPaperSettings'] = None,
        id: Optional[int] = None
    ):

        """
        Set a custom [wallpaper](https://core.telegram.org/api/wallpapers) in a specific private chat with another user.

        Args:
            peer ('TypeInputPeer'): The private chat where the wallpaper will be set
            for_both (bool, optional): Only for [Premium](https://core.telegram.org/api/premium) users, sets the specified wallpaper for both users of the chat, without requiring confirmation from the other user.
            revert (bool, optional): If we don't like the new wallpaper the other user of the chat has chosen for us using the for_both flag, we can re-set our previous wallpaper just on our side using this flag.
            wallpaper (Optional['TypeInputWallPaper'], optional): The [wallpaper](https://core.telegram.org/api/wallpapers), obtained as described in the [wallpaper documentation](https://core.telegram.org/api/wallpapers#uploading-wallpapers); must not be provided when installing a wallpaper obtained from a [messageActionSetChatWallPaper](https://core.telegram.org/constructor/messageActionSetChatWallPaper) service message ( id must be provided, instead).
            settings (Optional['TypeWallPaperSettings'], optional): Wallpaper settings, obtained as described in the [wallpaper documentation](https://core.telegram.org/api/wallpapers#uploading-wallpapers) or from [messageActionSetChatWallPaper](https://core.telegram.org/constructor/messageActionSetChatWallPaper). wallpaper. settings.
            id (Optional[int], optional): If the wallpaper was obtained from a [messageActionSetChatWallPaper](https://core.telegram.org/constructor/messageActionSetChatWallPaper) service message, must contain the ID of that message.
        """

        self.peer = peer
        self.for_both = for_both
        self.revert = revert
        self.wallpaper = wallpaper
        self.settings = settings
        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe1\xca\xfa\x8f' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.for_both, 3)
                flags(self.revert, 4)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.wallpaper, 0):
                    writer.object(
                        self.wallpaper,
                        group_id=0X6C8C6F31
                    )

                if flags(self.settings, 2):
                    writer.object(
                        self.settings,
                        group_id=0X28E332CF
                    )

                if flags(self.id, 1):
                    writer.int(self.id)

            return writer.getvalue()