
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_user import TypeInputUser


class SetGameScore(TLRequest[TypeUpdates]):
    """
    Use this method to set the score of the specified user in a game sent as a normal message (bots only).

    **Bots can use this method**

    Raises:
        `400`BotScoreNotModifiedError: The score wasn't modified.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`ScoreInvalidError: The specified game score is invalid.
        `400`UserBotRequiredError: This method can only be called by a bot.

    """

    _id = 0X8EF8ECC0
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        user_id: 'TypeInputUser',
        score: int,
        edit_message: bool = False,
        force: bool = False
    ):

        """
        Use this method to set the score of the specified user in a game sent as a normal message (bots only).

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): Unique identifier of target chat
            id (int): Identifier of the sent message
            user_id ('TypeInputUser'): User identifier
            score (int): New score
            edit_message (bool, optional): Set this flag if the game message should be automatically edited to include the current scoreboard
            force (bool, optional): Set this flag if the high score is allowed to decrease. This can be useful when fixing mistakes or banning cheaters
        """

        self.peer = peer
        self.id = id
        self.user_id = user_id
        self.score = score
        self.edit_message = edit_message
        self.force = force

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc0\xec\xf8\x8e' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.edit_message, 0)
                flags(self.force, 1)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.id)
                writer.object(
                    self.user_id,
                    group_id=0XB628962F
                )
                writer.int(self.score)

            return writer.getvalue()