
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.inline_bot_web_view import TypeInlineBotWebView
    from ...types.inline_bot_switch_pm import TypeInlineBotSwitchPM
    from ...types.input_bot_inline_result import TypeInputBotInlineResult


class SetInlineBotResults(TLRequest[bool]):
    """
    Answer an inline query, for bots only

    **Bots can use this method**

    Raises:
        `400`ArticleTitleEmptyError: The title of the article is empty.
        `400`AudioContentUrlEmptyError: The remote URL specified in the content field is empty.
        `400`AudioTitleEmptyError: An empty audio title was provided.
        `400`ButtonDataInvalidError: The data of one or more of the buttons you provided is invalid.
        `400`ButtonTypeInvalidError: The type of one or more of the buttons you provided is invalid.
        `400`ButtonUrlInvalidError: Button URL invalid.
        `400`DocumentInvalidError: The specified document is invalid.
        `400`FileContentTypeInvalidError: File content-type is invalid.
        `400`FileTitleEmptyError: An empty file title was specified.
        `400`GifContentTypeInvalidError: GIF content-type invalid.
        `400`MessageEmptyError: The provided message is empty.
        `400`MessageTooLongError: The provided message is too long.
        `400`NextOffsetInvalidError: The specified offset is longer than 64 bytes.
        `400`PeerTypesInvalidError: The passed [keyboardButtonSwitchInline](https://core.telegram.org/constructor/keyboardButtonSwitchInline).`peer_types` field is invalid.
        `400`PhotoContentTypeInvalidError: Photo mime-type invalid.
        `400`PhotoContentUrlEmptyError: Photo URL invalid.
        `400`PhotoInvalidError: Photo invalid.
        `400`PhotoThumbUrlEmptyError: Photo thumbnail URL is empty.
        `400`QueryIdInvalidError: The query ID is invalid.
        `400`ReplyMarkupInvalidError: The provided reply markup is invalid.
        `400`ResultsTooMuchError: Too many results were provided.
        `400`ResultIdDuplicateError: You provided a duplicate result ID.
        `400`ResultIdInvalidError: One of the specified result IDs is invalid.
        `400`ResultTypeInvalidError: Result type invalid.
        `400`SendMessageMediaInvalidError: Invalid media provided.
        `400`SendMessageTypeInvalidError: The message type is invalid.
        `400`StartParamEmptyError: The start parameter is empty.
        `400`StartParamInvalidError: Start parameter invalid.
        `400`StickerDocumentInvalidError: The specified sticker document is invalid.
        `400`SwitchPmTextEmptyError: The switch_pm.text field was empty.
        `400`SwitchWebviewUrlInvalidError: The URL specified in switch_webview.url is invalid!
        `400`UrlInvalidError: Invalid URL provided.
        `400`UserBotRequiredError: This method can only be called by a bot.
        `400`VideoContentTypeInvalidError: The video's content type is invalid.
        `400`VideoTitleEmptyError: The specified video title is empty.
        `400`WebdocumentInvalidError: Invalid webdocument URL provided.
        `400`WebdocumentMimeInvalidError: Invalid webdocument mime type provided.
        `400`WebdocumentSizeTooBigError: Webdocument is too big!
        `400`WebdocumentUrlInvalidError: The specified webdocument URL is invalid.
        `403`UserBotInvalidError: User accounts must provide the `bot` method parameter when calling this method. If there is no such method parameter, this method can only be invoked by bot accounts.

    """

    _id = 0XBB12A419
    _result_id = 0X43B904E1

    def __init__(
        self,
        query_id: int,
        results: List['TypeInputBotInlineResult'],
        cache_time: int,
        gallery: bool = False,
        private: bool = False,
        next_offset: Optional[str] = None,
        switch_pm: Optional['TypeInlineBotSwitchPM'] = None,
        switch_webview: Optional['TypeInlineBotWebView'] = None
    ):

        """
        Answer an inline query, for bots only

        **Bots can use this method**

        Args:
            query_id (int): Unique identifier for the answered query
            results (List['TypeInputBotInlineResult']): Vector of results for the inline query
            cache_time (int): The maximum amount of time in seconds that the result of the inline query may be cached on the server. Defaults to 300.
            gallery (bool, optional): Set this flag if the results are composed of media files
            private (bool, optional): Set this flag if results may be cached on the server side only for the user that sent the query. By default, results may be returned to any user who sends the same query
            next_offset (Optional[str], optional): Pass the offset that a client should send in the next query with the same text to receive more results. Pass an empty string if there are no more results or if you don't support pagination. Offset length can't exceed 64 bytes.
            switch_pm (Optional['TypeInlineBotSwitchPM'], optional): If passed, clients will display a button on top of the remaining inline result list with the specified text, that switches the user to a private chat with the bot and sends the bot a start message with a certain parameter.
            switch_webview (Optional['TypeInlineBotWebView'], optional): If passed, clients will display a button on top of the remaining inline result list with the specified text, that switches the user to the specified [inline mode mini app](https://core.telegram.org/api/bots/webapps#inline-mode-mini-apps).
        """

        self.query_id = query_id
        self.results = results
        self.cache_time = cache_time
        self.gallery = gallery
        self.private = private
        self.next_offset = next_offset
        self.switch_pm = switch_pm
        self.switch_webview = switch_webview

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x19\xa4\x12\xbb' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.gallery, 0)
                flags(self.private, 1)
                writer.long(self.query_id)
                writer.vector(
                    self.results,
                    lambda value: writer.object(
                        value,
                        group_id=0X84BAC7FB
                    )
                )
                writer.int(self.cache_time)

                if flags(self.next_offset, 2):
                    writer.string(self.next_offset)

                if flags(self.switch_pm, 3):
                    writer.object(
                        self.switch_pm,
                        group_id=0XEB2726E6
                    )

                if flags(self.switch_webview, 4):
                    writer.object(
                        self.switch_webview,
                        group_id=0XFCF33679
                    )

            return writer.getvalue()