
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_peer import TypeInputPeer


class StartBot(TLRequest[TypeUpdates]):
    """
    Start a conversation with a bot using a [deep linking parameter](https://core.telegram.org/api/links#bot-links)

    Raises:
        `400`BotInvalidError: This is not a valid bot.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`StartParamEmptyError: The start parameter is empty.
        `400`StartParamInvalidError: Start parameter invalid.
        `400`StartParamTooLongError: Start parameter is too long.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `500`RandomIdDuplicateError: You provided a random ID that was already used.

    """

    _id = 0XE6DF7378
    _result_id = 0XD68D29C0

    def __init__(
        self,
        bot: 'TypeInputUser',
        peer: 'TypeInputPeer',
        start_param: str,
        random_id: int = None
    ):

        """
        Start a conversation with a bot using a [deep linking parameter](https://core.telegram.org/api/links#bot-links)

        Args:
            bot ('TypeInputUser'): The bot
            peer ('TypeInputPeer'): The chat where to start the bot, can be the bot's private chat or a group
            start_param (str): [Deep linking parameter](https://core.telegram.org/api/links#bot-links)
            random_id (int, optional): Random ID to avoid resending the same message
        """

        self.bot = bot
        self.peer = peer
        self.start_param = start_param
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'xs\xdf\xe6' if boxed else b'') as writer:
            writer.object(
                self.bot,
                group_id=0XB628962F
            )
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.long(self.random_id)
            writer.string(self.start_param)

            return writer.getvalue()