
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.payments.stars_revenue_withdrawal_url import TypePaymentsStarsRevenueWithdrawalUrl


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_check_password_srp import TypeInputCheckPasswordSRP


class GetStarsRevenueWithdrawalUrl(TLRequest[TypePaymentsStarsRevenueWithdrawalUrl]):
    """
    Withdraw funds from a channel or bot's [star balance](https://core.telegram.org/api/stars#withdrawing-stars).

    Raises:
        `400`PasswordHashInvalidError: The provided password hash is invalid.
        `400`PasswordMissingError: You must [enable 2FA](https://core.telegram.org/api/srp) before executing this operation.
        `400`PasswordTooFreshError: The password was modified less than 24 hours ago, try again in {seconds} seconds.
        `400`SessionTooFreshError: This session was created less than 24 hours ago, try again in {seconds} seconds.

    """

    _id = 0X2433DC92
    _result_id = 0X99B1A86E

    def __init__(
        self,
        peer: 'TypeInputPeer',
        password: 'TypeInputCheckPasswordSRP',
        ton: bool = False,
        amount: Optional[int] = None
    ):

        """
        Withdraw funds from a channel or bot's [star balance](https://core.telegram.org/api/stars#withdrawing-stars).

        Args:
            peer ('TypeInputPeer'): Channel or bot from which to withdraw funds.
            password ('TypeInputCheckPasswordSRP'): 2FA password, see [here](https://core.telegram.org/api/srp#using-the-2fa-password) for more info.
            ton (bool, optional): ...
            amount (Optional[int], optional): ...
        """

        self.peer = peer
        self.password = password
        self.ton = ton
        self.amount = amount

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x92\xdc3$' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.ton, 0)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.amount, 1):
                    writer.long(self.amount)
                writer.object(
                    self.password,
                    group_id=0X9F1A3F43
                )

            return writer.getvalue()