
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.payments.stars_status import TypePaymentsStarsStatus


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetStarsTransactions(TLRequest[TypePaymentsStarsStatus]):
    """
    Fetch [Telegram Stars transactions](https://core.telegram.org/api/stars#balance-and-transaction-history).

    **Bots can use this method**

    Raises:
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X69DA4557
    _result_id = 0XC88B272F

    def __init__(
        self,
        peer: 'TypeInputPeer',
        offset: str,
        limit: int,
        inbound: bool = False,
        outbound: bool = False,
        ascending: bool = False,
        ton: bool = False,
        subscription_id: Optional[str] = None
    ):

        """
        Fetch [Telegram Stars transactions](https://core.telegram.org/api/stars#balance-and-transaction-history).

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): Fetch the transaction history of the peer ( [inputPeerSelf](https://core.telegram.org/constructor/inputPeerSelf) or a bot we own).
            offset (str): [Offset for pagination, obtained from the returned next_offset, initially an empty string](https://core.telegram.org/api/offsets).
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            inbound (bool, optional): If set, fetches only incoming transactions.
            outbound (bool, optional): If set, fetches only outgoing transactions.
            ascending (bool, optional): Return transactions in ascending order by date (instead of descending order by date).
            ton (bool, optional): ...
            subscription_id (Optional[str], optional): If set, fetches only transactions for the specified [Telegram Star subscription](https://core.telegram.org/api/stars#star-subscriptions).
        """

        self.peer = peer
        self.offset = offset
        self.limit = limit
        self.inbound = inbound
        self.outbound = outbound
        self.ascending = ascending
        self.ton = ton
        self.subscription_id = subscription_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'WE\xdai' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.inbound, 0)
                flags(self.outbound, 1)
                flags(self.ascending, 2)
                flags(self.ton, 4)

                if flags(self.subscription_id, 3):
                    writer.string(self.subscription_id)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.string(self.offset)
                writer.int(self.limit)

            return writer.getvalue()