
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Int, Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class CreateGroupCall(TLRequest[TypeUpdates]):
    """
    Create a group call or livestream

    Raises:
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`CreateCallFailedError: An error occurred while creating the call.
        `400`GroupcallAlreadyDiscardedError: The group call was already discarded.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`ScheduleDateInvalidError: Invalid schedule date provided.

    """

    _id = 0X48CDC6D8
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        rtmp_stream: bool = False,
        title: Optional[str] = None,
        schedule_date: Optional[int] = None,
        random_id: int = None
    ):

        """
        Create a group call or livestream

        Args:
            peer ('TypeInputPeer'): Associate the group call or livestream to the provided [group/supergroup/channel](https://core.telegram.org/api/channel)
            rtmp_stream (bool, optional): Whether RTMP stream support should be enabled: only the [group/supergroup/channel](https://core.telegram.org/api/channel) owner can use this flag.
            title (Optional[str], optional): Call title
            schedule_date (Optional[int], optional): For scheduled group call or livestreams, the absolute date when the group call will start
            random_id (int, optional): Unique client message ID required to prevent creation of duplicate group calls
        """

        self.peer = peer
        self.rtmp_stream = rtmp_stream
        self.title = title
        self.schedule_date = schedule_date
        self.random_id = Int() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd8\xc6\xcdH' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.rtmp_stream, 2)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.random_id)

                if flags(self.title, 0):
                    writer.string(self.title)

                if flags(self.schedule_date, 1):
                    writer.int(self.schedule_date)

            return writer.getvalue()