
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_phone_call import TypeInputPhoneCall
    from ...types.phone_call_discard_reason import TypePhoneCallDiscardReason


class DiscardCall(TLRequest[TypeUpdates]):
    """
    Refuse or end running call

    Raises:
        `400`CallAlreadyAcceptedError: The call was already accepted.
        `400`CallPeerInvalidError: The provided call peer object is invalid.
        `500`CallOccupyFailedError: The call failed because the user is already making another call.

    """

    _id = 0XB2CBC1C0
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPhoneCall',
        duration: int,
        reason: 'TypePhoneCallDiscardReason',
        connection_id: int,
        video: bool = False
    ):

        """
        Refuse or end running call

        Args:
            peer ('TypeInputPhoneCall'): The phone call
            duration (int): Call duration
            reason ('TypePhoneCallDiscardReason'): Why was the call discarded
            connection_id (int): Preferred libtgvoip relay ID
            video (bool, optional): Whether this is a video call
        """

        self.peer = peer
        self.duration = duration
        self.reason = reason
        self.connection_id = connection_id
        self.video = video

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc0\xc1\xcb\xb2' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.video, 0)
                writer.object(
                    self.peer,
                    group_id=0X3E51BD6B
                )
                writer.int(self.duration)
                writer.object(
                    self.reason,
                    group_id=0X7AB7DC85
                )
                writer.long(self.connection_id)

            return writer.getvalue()