
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Int, Writer
from ...types.phone.phone_call import TypePhonePhoneCall


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.phone_call_protocol import TypePhoneCallProtocol


class RequestCall(TLRequest[TypePhonePhoneCall]):
    """
    Start a telegram phone call

    Raises:
        `400`CallProtocolFlagsInvalidError: Call protocol flags invalid.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`ParticipantVersionOutdatedError: The other participant does not use an up to date telegram client with support for calls.
        `400`UserIdInvalidError: The provided user ID is invalid.
        `403`UserIsBlockedError: You were blocked by this user.
        `403`UserPrivacyRestrictedError: The user's privacy settings do not allow you to do this.

    """

    _id = 0X42FF96ED
    _result_id = 0X6D677A4E

    def __init__(
        self,
        user_id: 'TypeInputUser',
        g_a_hash: bytes,
        protocol: 'TypePhoneCallProtocol',
        video: bool = False,
        random_id: int = None
    ):

        """
        Start a telegram phone call

        Args:
            user_id ('TypeInputUser'): Destination of the phone call
            g_a_hash (bytes): [Parameter for E2E encryption key exchange](https://core.telegram.org/api/end-to-end/voice-calls)
            protocol ('TypePhoneCallProtocol'): Phone call settings
            video (bool, optional): Whether to start a video call
            random_id (int, optional): Random ID to avoid resending the same object
        """

        self.user_id = user_id
        self.g_a_hash = g_a_hash
        self.protocol = protocol
        self.video = video
        self.random_id = Int() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xed\x96\xffB' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.video, 0)
                writer.object(
                    self.user_id,
                    group_id=0XB628962F
                )
                writer.int(self.random_id)
                writer.bytes(self.g_a_hash)
                writer.object(
                    self.protocol,
                    group_id=0X11AF407E
                )

            return writer.getvalue()