
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List
from ...types.file_hash import TypeFileHash
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class ReuploadCdnFile(TLRequest[List[TypeFileHash]]):
    """
    Request a reupload of a certain file to a [CDN DC](https://core.telegram.org/cdn).

    **Bots can use this method**

    Raises:
        `400`CdnMethodInvalidError: You can't call this method in a CDN DC.
        `400`FileTokenInvalidError: The master DC did not accept the `file_token` (e.g., the token has expired). Continue downloading the file from the master DC using upload.getFile.
        `400`LocationInvalidError: The provided location is invalid.
        `400`RequestTokenInvalidError: The master DC did not accept the `request_token` from the CDN DC. Continue downloading the file from the master DC using upload.getFile.
        `400`RsaDecryptFailedError: Internal RSA decryption failed.
        `500`CdnUploadTimeoutError: A server-side timeout occurred while reuploading the file to the CDN DC.

    """

    _id = 0X9B2754A8

    def __init__(
        self,
        file_token: bytes,
        request_token: bytes
    ):

        """
        Request a reupload of a certain file to a [CDN DC](https://core.telegram.org/cdn).

        **Bots can use this method**

        Args:
            file_token (bytes): File token
            request_token (bytes): Request token
        """

        self.file_token = file_token
        self.request_token = request_token

    def to_bytes(self, boxed: bool=True):
        with Writer(b"\xa8T'\x9b" if boxed else b'') as writer:
            writer.bytes(self.file_token)
            writer.bytes(self.request_token)

            return writer.getvalue()