
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class BankCardOpenUrl(TLObject, family='TypeBankCardOpenUrl'):
    """
    Credit card info URL provided by the bank
    """

    _id = 0XF568028A
    _group_id = 0X5EDC4401

    def __init__(
        self,
        url: str,
        name: str
    ):

        """
        Credit card info URL provided by the bank

        Args:
            url (str): Info URL
            name (str): Bank name
        """

        self.url = url
        self.name = name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8a\x02h\xf5' if boxed else b'') as writer:
            writer.string(self.url)
            writer.string(self.name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        name_ = reader.string()

        return cls(
            url=url_,
            name=name_
        )

TypeBankCardOpenUrl = BankCardOpenUrl