
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo import TypePhoto
    from .document import TypeDocument
    from .bot_command import TypeBotCommand
    from .bot_menu_button import TypeBotMenuButton
    from .bot_app_settings import TypeBotAppSettings
    from ...gadgets.byteutils import Reader
    from .bot_verifier_settings import TypeBotVerifierSettings


class BotInfo(TLObject, family='TypeBotInfo'):
    """
    Info about bots (available bot commands, etc)
    """

    _id = 0X4D8A0299
    _group_id = 0XAD8F02B7

    def __init__(
        self,
        has_preview_medias: bool = False,
        user_id: Optional[int] = None,
        description: Optional[str] = None,
        description_photo: Optional['TypePhoto'] = None,
        description_document: Optional['TypeDocument'] = None,
        commands: Optional[List['TypeBotCommand']] = None,
        menu_button: Optional['TypeBotMenuButton'] = None,
        privacy_policy_url: Optional[str] = None,
        app_settings: Optional['TypeBotAppSettings'] = None,
        verifier_settings: Optional['TypeBotVerifierSettings'] = None
    ):

        """
        Info about bots (available bot commands, etc)

        Args:
            has_preview_medias (bool, optional): If set, the bot has some [preview medias for the configured Main Mini App, see here](https://core.telegram.org/api/bots/webapps#main-mini-app-previews) for more info on Main Mini App preview medias.
            user_id (Optional[int], optional): ID of the bot
            description (Optional[str], optional): Description of the bot
            description_photo (Optional['TypePhoto'], optional): Description photo
            description_document (Optional['TypeDocument'], optional): Description animation in MPEG4 format
            commands (Optional[List['TypeBotCommand']], optional): Bot commands that can be used in the chat
            menu_button (Optional['TypeBotMenuButton'], optional): Indicates the action to execute when pressing the in-UI menu button for bots
            privacy_policy_url (Optional[str], optional): The HTTP link to the privacy policy of the bot. If not set, then the /privacy command must be used, if supported by the bot (i.e. if it's present in the commands vector). If it isn't supported, then [https://telegram.org/privacy-tpa](https://telegram.org/privacy-tpa) must be opened, instead.
            app_settings (Optional['TypeBotAppSettings'], optional): [Mini app](https://core.telegram.org/api/bots/webapps) settings
            verifier_settings (Optional['TypeBotVerifierSettings'], optional): ...
        """

        self.has_preview_medias = has_preview_medias
        self.user_id = user_id
        self.description = description
        self.description_photo = description_photo
        self.description_document = description_document
        self.commands = commands
        self.menu_button = menu_button
        self.privacy_policy_url = privacy_policy_url
        self.app_settings = app_settings
        self.verifier_settings = verifier_settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x99\x02\x8aM' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_preview_medias, 6)

                if flags(self.user_id, 0):
                    writer.long(self.user_id)

                if flags(self.description, 1):
                    writer.string(self.description)

                if flags(self.description_photo, 4):
                    writer.object(
                        self.description_photo,
                        group_id=0XDDAD9CAC
                    )

                if flags(self.description_document, 5):
                    writer.object(
                        self.description_document,
                        group_id=0X6547BD50
                    )

                if flags(self.commands, 2):
                    writer.vector(
                        self.commands,
                        lambda value: writer.object(
                            value,
                            group_id=0X3A20FA17
                        )
                    )

                if flags(self.menu_button, 3):
                    writer.object(
                        self.menu_button,
                        group_id=0XBFCA576A
                    )

                if flags(self.privacy_policy_url, 7):
                    writer.string(self.privacy_policy_url)

                if flags(self.app_settings, 8):
                    writer.object(
                        self.app_settings,
                        group_id=0X95652DC8
                    )

                if flags(self.verifier_settings, 9):
                    writer.object(
                        self.verifier_settings,
                        group_id=0X349433CA
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = (
            reader.long()
            if flags(0) else None
        )

        description_ = (
            reader.string()
            if flags(1) else None
        )

        description_photo_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(4) else None
        )

        description_document_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(5) else None
        )

        commands_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3A20FA17
                )
            )
            if flags(2) else None
        )

        menu_button_ = (
            reader.object(
                group_id=0XBFCA576A
            )
            if flags(3) else None
        )

        privacy_policy_url_ = (
            reader.string()
            if flags(7) else None
        )

        app_settings_ = (
            reader.object(
                group_id=0X95652DC8
            )
            if flags(8) else None
        )

        verifier_settings_ = (
            reader.object(
                group_id=0X349433CA
            )
            if flags(9) else None
        )

        return cls(
            has_preview_medias=flags(6),
            user_id=user_id_,
            description=description_,
            description_photo=description_photo_,
            description_document=description_document_,
            commands=commands_,
            menu_button=menu_button_,
            privacy_policy_url=privacy_policy_url_,
            app_settings=app_settings_,
            verifier_settings=verifier_settings_
        )

TypeBotInfo = BotInfo