
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .business_weekly_open import TypeBusinessWeeklyOpen


class BusinessWorkHours(TLObject, family='TypeBusinessWorkHours'):
    """
    Specifies a set of [Telegram Business opening hours](https://core.telegram.org/api/business#opening-hours).
    """

    _id = 0X8C92B098
    _group_id = 0XC0979D8

    def __init__(
        self,
        timezone_id: str,
        weekly_open: List['TypeBusinessWeeklyOpen'],
        open_now: bool = False
    ):

        """
        Specifies a set of [Telegram Business opening hours](https://core.telegram.org/api/business#opening-hours).

        Args:
            timezone_id (str): An ID of one of the timezones returned by [help.getTimezonesList](https://core.telegram.org/method/help.getTimezonesList).    The timezone ID is contained [timezone](https://core.telegram.org/constructor/timezone). id, a human-readable, localized name of the timezone is available in [timezone](https://core.telegram.org/constructor/timezone). name and the [timezone](https://core.telegram.org/constructor/timezone). utc_offset field contains the UTC offset in seconds, which may be displayed in hh:mm format by the client together with the human-readable name (i.e. $name UTC -01:00).
            weekly_open (List['TypeBusinessWeeklyOpen']): A list of time intervals (max 28) represented by [businessWeeklyOpen](https://core.telegram.org/constructor/businessWeeklyOpen), indicating the opening hours of their business.
            open_now (bool, optional): Ignored if set while invoking [account.updateBusinessWorkHours](https://core.telegram.org/method/account.updateBusinessWorkHours), only returned by the server in [userFull](https://core.telegram.org/constructor/userFull). business_work_hours, indicating whether the business is currently open according to the current time and the values in weekly_open and timezone.
        """

        self.timezone_id = timezone_id
        self.weekly_open = weekly_open
        self.open_now = open_now

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x98\xb0\x92\x8c' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.open_now, 0)
                writer.string(self.timezone_id)
                writer.vector(
                    self.weekly_open,
                    lambda value: writer.object(
                        value,
                        group_id=0XE04B1E9F
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        timezone_id_ = reader.string()
        weekly_open_ = reader.vector(
            lambda: reader.object(
                group_id=0XE04B1E9F
            )
        )

        return cls(
            timezone_id=timezone_id_,
            weekly_open=weekly_open_,
            open_now=flags(0)
        )

TypeBusinessWorkHours = BusinessWorkHours