
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .cdn_public_key import TypeCdnPublicKey
    from ...gadgets.byteutils import Reader


class CdnConfig(TLObject, family='TypeCdnConfig'):
    """
    Configuration for [CDN](https://core.telegram.org/cdn) file downloads.
    """

    _id = 0X5725E40A
    _group_id = 0XBC9B1015

    def __init__(
        self,
        public_keys: List['TypeCdnPublicKey']
    ):

        """
        Configuration for [CDN](https://core.telegram.org/cdn) file downloads.

        Args:
            public_keys (List['TypeCdnPublicKey']): Vector of public keys to use only during handshakes to [CDN](https://core.telegram.org/cdn) DCs.
        """

        self.public_keys = public_keys

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\n\xe4%W' if boxed else b'') as writer:
            writer.vector(
                self.public_keys,
                lambda value: writer.object(
                    value,
                    group_id=0X144059E1
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        public_keys_ = reader.vector(
            lambda: reader.object(
                group_id=0X144059E1
            )
        )

        return cls(
            public_keys=public_keys_
        )

TypeCdnConfig = CdnConfig