
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .chat_admin_rights import TypeChatAdminRights
    from .chat_banned_rights import TypeChatBannedRights
    from ...gadgets.byteutils import Reader


class ChannelParticipant(TLObject, family='TypeChannelParticipant'):
    """
    Channel/supergroup participant
    """

    _id = 0XCB397619
    _group_id = 0X21CCC4A0

    def __init__(
        self,
        user_id: int,
        date: int,
        subscription_until_date: Optional[int] = None
    ):

        """
        Channel/supergroup participant

        Args:
            user_id (int): Participant user ID
            date (int): Date joined
            subscription_until_date (Optional[int], optional): If set, contains the expiration date of the current [Telegram Star subscription period](https://core.telegram.org/api/stars#star-subscriptions) for the specified participant.
        """

        self.user_id = user_id
        self.date = date
        self.subscription_until_date = subscription_until_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x19v9\xcb' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.user_id)
                writer.int(self.date)

                if flags(self.subscription_until_date, 0):
                    writer.int(self.subscription_until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.long()
        date_ = reader.int()
        subscription_until_date_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            user_id=user_id_,
            date=date_,
            subscription_until_date=subscription_until_date_
        )

class ChannelParticipantSelf(TLObject, family='TypeChannelParticipant'):
    """
    Myself
    """

    _id = 0X4F607BEF
    _group_id = 0X21CCC4A0

    def __init__(
        self,
        user_id: int,
        inviter_id: int,
        date: int,
        via_request: bool = False,
        subscription_until_date: Optional[int] = None
    ):

        """
        Myself

        Args:
            user_id (int): User ID
            inviter_id (int): User that invited me to the channel/supergroup
            date (int): When did I join the channel/supergroup
            via_request (bool, optional): Whether I joined upon specific approval of an admin
            subscription_until_date (Optional[int], optional): If set, contains the expiration date of the current [Telegram Star subscription period](https://core.telegram.org/api/stars#star-subscriptions) for the specified participant.
        """

        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date
        self.via_request = via_request
        self.subscription_until_date = subscription_until_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xef{`O' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.via_request, 0)
                writer.long(self.user_id)
                writer.long(self.inviter_id)
                writer.int(self.date)

                if flags(self.subscription_until_date, 1):
                    writer.int(self.subscription_until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.long()
        inviter_id_ = reader.long()
        date_ = reader.int()
        subscription_until_date_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            user_id=user_id_,
            inviter_id=inviter_id_,
            date=date_,
            via_request=flags(0),
            subscription_until_date=subscription_until_date_
        )

class ChannelParticipantCreator(TLObject, family='TypeChannelParticipant'):
    """
    Channel/supergroup creator
    """

    _id = 0X2FE601D3
    _group_id = 0X21CCC4A0

    def __init__(
        self,
        user_id: int,
        admin_rights: 'TypeChatAdminRights',
        rank: Optional[str] = None
    ):

        """
        Channel/supergroup creator

        Args:
            user_id (int): User ID
            admin_rights ('TypeChatAdminRights'): Creator admin rights
            rank (Optional[str], optional): The role (rank) of the group creator in the group: just an arbitrary string, admin by default
        """

        self.user_id = user_id
        self.admin_rights = admin_rights
        self.rank = rank

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd3\x01\xe6/' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.user_id)
                writer.object(
                    self.admin_rights,
                    group_id=0X2A03C5CB
                )

                if flags(self.rank, 0):
                    writer.string(self.rank)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.long()
        admin_rights_ = reader.object(
            group_id=0X2A03C5CB
        )

        rank_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            user_id=user_id_,
            admin_rights=admin_rights_,
            rank=rank_
        )

class ChannelParticipantAdmin(TLObject, family='TypeChannelParticipant'):
    """
    Admin
    """

    _id = 0X34C3BB53
    _group_id = 0X21CCC4A0

    def __init__(
        self,
        user_id: int,
        promoted_by: int,
        date: int,
        admin_rights: 'TypeChatAdminRights',
        can_edit: bool = False,
        is_self: bool = False,
        inviter_id: Optional[int] = None,
        rank: Optional[str] = None
    ):

        """
        Admin

        Args:
            user_id (int): Admin user ID
            promoted_by (int): User that promoted the user to admin
            date (int): When did the user join
            admin_rights ('TypeChatAdminRights'): Admin [rights](https://core.telegram.org/api/rights)
            can_edit (bool, optional): Can this admin promote other admins with the same permissions?
            is_self (bool, optional): Is this the current user
            inviter_id (Optional[int], optional): User that invited the admin to the channel/group
            rank (Optional[str], optional): The role (rank) of the admin in the group: just an arbitrary string, admin by default
        """

        self.user_id = user_id
        self.promoted_by = promoted_by
        self.date = date
        self.admin_rights = admin_rights
        self.can_edit = can_edit
        self.is_self = is_self
        self.inviter_id = inviter_id
        self.rank = rank

    def to_bytes(self, boxed: bool=True):
        with Writer(b'S\xbb\xc34' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.can_edit, 0)
                flags(self.is_self, 1)
                writer.long(self.user_id)

                if flags(self.inviter_id, 1):
                    writer.long(self.inviter_id)
                writer.long(self.promoted_by)
                writer.int(self.date)
                writer.object(
                    self.admin_rights,
                    group_id=0X2A03C5CB
                )

                if flags(self.rank, 2):
                    writer.string(self.rank)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.long()
        inviter_id_ = (
            reader.long()
            if flags(1) else None
        )

        promoted_by_ = reader.long()
        date_ = reader.int()
        admin_rights_ = reader.object(
            group_id=0X2A03C5CB
        )

        rank_ = (
            reader.string()
            if flags(2) else None
        )

        return cls(
            user_id=user_id_,
            promoted_by=promoted_by_,
            date=date_,
            admin_rights=admin_rights_,
            can_edit=flags(0),
            is_self=flags(1),
            inviter_id=inviter_id_,
            rank=rank_
        )

class ChannelParticipantBanned(TLObject, family='TypeChannelParticipant'):
    """
    Banned/kicked user
    """

    _id = 0X6DF8014E
    _group_id = 0X21CCC4A0

    def __init__(
        self,
        peer: 'TypePeer',
        kicked_by: int,
        date: int,
        banned_rights: 'TypeChatBannedRights',
        left: bool = False
    ):

        """
        Banned/kicked user

        Args:
            peer ('TypePeer'): The banned peer
            kicked_by (int): User was kicked by the specified admin
            date (int): When did the user join the group
            banned_rights ('TypeChatBannedRights'): Banned [rights](https://core.telegram.org/api/rights)
            left (bool, optional): Whether the user has left the group
        """

        self.peer = peer
        self.kicked_by = kicked_by
        self.date = date
        self.banned_rights = banned_rights
        self.left = left

    def to_bytes(self, boxed: bool=True):
        with Writer(b'N\x01\xf8m' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.left, 0)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.long(self.kicked_by)
                writer.int(self.date)
                writer.object(
                    self.banned_rights,
                    group_id=0XDB47663A
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        kicked_by_ = reader.long()
        date_ = reader.int()
        banned_rights_ = reader.object(
            group_id=0XDB47663A
        )

        return cls(
            peer=peer_,
            kicked_by=kicked_by_,
            date=date_,
            banned_rights=banned_rights_,
            left=flags(0)
        )

class ChannelParticipantLeft(TLObject, family='TypeChannelParticipant'):
    """
    A participant that left the channel/supergroup
    """

    _id = 0X1B03F006
    _group_id = 0X21CCC4A0

    def __init__(
        self,
        peer: 'TypePeer'
    ):

        """
        A participant that left the channel/supergroup

        Args:
            peer ('TypePeer'): The peer that left
        """

        self.peer = peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x06\xf0\x03\x1b' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        return cls(
            peer=peer_
        )

TypeChannelParticipant = Union[
    ChannelParticipant,
    ChannelParticipantSelf,
    ChannelParticipantCreator,
    ChannelParticipantAdmin,
    ChannelParticipantBanned,
    ChannelParticipantLeft
]