
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .chat import TypeChat
    from .user import TypeUser
    from .photo import TypePhoto
    from .bot_verification import TypeBotVerification
    from ...gadgets.byteutils import Reader
    from .stars_subscription_pricing import TypeStarsSubscriptionPricing


class ChatInviteAlready(TLObject, family='TypeChatInvite'):
    """
    The user has already joined this chat
    """

    _id = 0X5A686D7C
    _group_id = 0X30688FE3

    def __init__(
        self,
        chat: 'TypeChat'
    ):

        """
        The user has already joined this chat

        Args:
            chat ('TypeChat'): The chat connected to the invite
        """

        self.chat = chat

    def to_bytes(self, boxed: bool=True):
        with Writer(b'|mhZ' if boxed else b'') as writer:
            writer.object(
                self.chat,
                group_id=0X73A5C0D9
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_ = reader.object(
            group_id=0X73A5C0D9
        )

        return cls(
            chat=chat_
        )

class ChatInvite(TLObject, family='TypeChatInvite'):
    """
    Chat invite info
    """

    _id = 0X5C9D3702
    _group_id = 0X30688FE3

    def __init__(
        self,
        title: str,
        photo: 'TypePhoto',
        participants_count: int,
        color: int,
        channel: bool = False,
        broadcast: bool = False,
        public: bool = False,
        megagroup: bool = False,
        request_needed: bool = False,
        verified: bool = False,
        scam: bool = False,
        fake: bool = False,
        can_refulfill_subscription: bool = False,
        about: Optional[str] = None,
        participants: Optional[List['TypeUser']] = None,
        subscription_pricing: Optional['TypeStarsSubscriptionPricing'] = None,
        subscription_form_id: Optional[int] = None,
        bot_verification: Optional['TypeBotVerification'] = None
    ):

        """
        Chat invite info

        Args:
            title (str): Chat/supergroup/channel title
            photo ('TypePhoto'): Chat/supergroup/channel photo
            participants_count (int): Participant count
            color (int): [Profile color palette ID](https://core.telegram.org/api/colors)
            channel (bool, optional): Whether this is a [channel/supergroup](https://core.telegram.org/api/channel) or a [normal group](https://core.telegram.org/api/channel)
            broadcast (bool, optional): Whether this is a [channel](https://core.telegram.org/api/channel)
            public (bool, optional): Whether this is a public [channel/supergroup](https://core.telegram.org/api/channel)
            megagroup (bool, optional): Whether this is a [supergroup](https://core.telegram.org/api/channel)
            request_needed (bool, optional): Whether the [join request](https://core.telegram.org/api/invites#join-requests) must be first approved by an administrator
            verified (bool, optional): Is this chat or channel verified by Telegram?
            scam (bool, optional): This chat is probably a scam
            fake (bool, optional): If set, this chat was reported by many users as a fake or scam: be careful when interacting with it.
            can_refulfill_subscription (bool, optional): If set, indicates that the user has already paid for the associated [Telegram Star subscriptions](https://core.telegram.org/api/stars#star-subscriptions) and it hasn't expired yet, so they may re-join the channel using [messages.importChatInvite](https://core.telegram.org/method/messages.importChatInvite) without repeating the payment.
            about (Optional[str], optional): Description of the group of channel
            participants (Optional[List['TypeUser']], optional): A few of the participants that are in the group
            subscription_pricing (Optional['TypeStarsSubscriptionPricing'], optional): For [Telegram Star subscriptions](https://core.telegram.org/api/stars#star-subscriptions), contains the pricing of the subscription the user must activate to join the private channel.
            subscription_form_id (Optional[int], optional): For [Telegram Star subscriptions](https://core.telegram.org/api/stars#star-subscriptions), the ID of the payment form for the subscription.
            bot_verification (Optional['TypeBotVerification'], optional): ...
        """

        self.title = title
        self.photo = photo
        self.participants_count = participants_count
        self.color = color
        self.channel = channel
        self.broadcast = broadcast
        self.public = public
        self.megagroup = megagroup
        self.request_needed = request_needed
        self.verified = verified
        self.scam = scam
        self.fake = fake
        self.can_refulfill_subscription = can_refulfill_subscription
        self.about = about
        self.participants = participants
        self.subscription_pricing = subscription_pricing
        self.subscription_form_id = subscription_form_id
        self.bot_verification = bot_verification

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x027\x9d\\' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.channel, 0)
                flags(self.broadcast, 1)
                flags(self.public, 2)
                flags(self.megagroup, 3)
                flags(self.request_needed, 6)
                flags(self.verified, 7)
                flags(self.scam, 8)
                flags(self.fake, 9)
                flags(self.can_refulfill_subscription, 11)
                writer.string(self.title)

                if flags(self.about, 5):
                    writer.string(self.about)
                writer.object(
                    self.photo,
                    group_id=0XDDAD9CAC
                )
                writer.int(self.participants_count)

                if flags(self.participants, 4):
                    writer.vector(
                        self.participants,
                        lambda value: writer.object(
                            value,
                            group_id=0X9BABE43A
                        )
                    )
                writer.int(self.color)

                if flags(self.subscription_pricing, 10):
                    writer.object(
                        self.subscription_pricing,
                        group_id=0XB0E97E9F
                    )

                if flags(self.subscription_form_id, 12):
                    writer.long(self.subscription_form_id)

                if flags(self.bot_verification, 13):
                    writer.object(
                        self.bot_verification,
                        group_id=0X80813E55
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.string()
        about_ = (
            reader.string()
            if flags(5) else None
        )

        photo_ = reader.object(
            group_id=0XDDAD9CAC
        )

        participants_count_ = reader.int()
        participants_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X9BABE43A
                )
            )
            if flags(4) else None
        )

        color_ = reader.int()
        subscription_pricing_ = (
            reader.object(
                group_id=0XB0E97E9F
            )
            if flags(10) else None
        )

        subscription_form_id_ = (
            reader.long()
            if flags(12) else None
        )

        bot_verification_ = (
            reader.object(
                group_id=0X80813E55
            )
            if flags(13) else None
        )

        return cls(
            title=title_,
            photo=photo_,
            participants_count=participants_count_,
            color=color_,
            channel=flags(0),
            broadcast=flags(1),
            public=flags(2),
            megagroup=flags(3),
            request_needed=flags(6),
            verified=flags(7),
            scam=flags(8),
            fake=flags(9),
            can_refulfill_subscription=flags(11),
            about=about_,
            participants=participants_,
            subscription_pricing=subscription_pricing_,
            subscription_form_id=subscription_form_id_,
            bot_verification=bot_verification_
        )

class ChatInvitePeek(TLObject, family='TypeChatInvite'):
    """
    A chat invitation that also allows peeking into the group to read messages without joining it.
    """

    _id = 0X61695CB0
    _group_id = 0X30688FE3

    def __init__(
        self,
        chat: 'TypeChat',
        expires: int
    ):

        """
        A chat invitation that also allows peeking into the group to read messages without joining it.

        Args:
            chat ('TypeChat'): Chat information
            expires (int): Read-only anonymous access to this group will be revoked at this date
        """

        self.chat = chat
        self.expires = expires

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb0\\ia' if boxed else b'') as writer:
            writer.object(
                self.chat,
                group_id=0X73A5C0D9
            )
            writer.int(self.expires)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_ = reader.object(
            group_id=0X73A5C0D9
        )

        expires_ = reader.int()

        return cls(
            chat=chat_,
            expires=expires_
        )

TypeChatInvite = Union[
    ChatInviteAlready,
    ChatInvite,
    ChatInvitePeek
]