
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..peer import TypePeer
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..text_with_entities import TypeTextWithEntities
    from ....gadgets.byteutils import Reader


class ChatlistInviteAlready(TLObject, family='TypeChatlistsChatlistInvite'):
    """
    Updated info about a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links) we already imported.
    """

    _id = 0XFA87F659
    _group_id = 0X19478009

    def __init__(
        self,
        filter_id: int,
        missing_peers: List['TypePeer'],
        already_peers: List['TypePeer'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Updated info about a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links) we already imported.

        Args:
            filter_id (int): ID of the imported folder
            missing_peers (List['TypePeer']): New peers to be imported
            already_peers (List['TypePeer']): Peers that were already imported
            chats (List['TypeChat']): Related chat information
            users (List['TypeUser']): Related user information
        """

        self.filter_id = filter_id
        self.missing_peers = missing_peers
        self.already_peers = already_peers
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Y\xf6\x87\xfa' if boxed else b'') as writer:
            writer.int(self.filter_id)
            writer.vector(
                self.missing_peers,
                lambda value: writer.object(
                    value,
                    group_id=0XB4DECBCA
                )
            )
            writer.vector(
                self.already_peers,
                lambda value: writer.object(
                    value,
                    group_id=0XB4DECBCA
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        filter_id_ = reader.int()
        missing_peers_ = reader.vector(
            lambda: reader.object(
                group_id=0XB4DECBCA
            )
        )

        already_peers_ = reader.vector(
            lambda: reader.object(
                group_id=0XB4DECBCA
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            filter_id=filter_id_,
            missing_peers=missing_peers_,
            already_peers=already_peers_,
            chats=chats_,
            users=users_
        )

class ChatlistInvite(TLObject, family='TypeChatlistsChatlistInvite'):
    """
    Info about a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).
    """

    _id = 0XF10ECE2F
    _group_id = 0X19478009

    def __init__(
        self,
        title: 'TypeTextWithEntities',
        peers: List['TypePeer'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        title_noanimate: bool = False,
        emoticon: Optional[str] = None
    ):

        """
        Info about a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).

        Args:
            title ('TypeTextWithEntities'): Name of the link
            peers (List['TypePeer']): Supergroups and channels to join
            chats (List['TypeChat']): Related chat information
            users (List['TypeUser']): Related user information
            title_noanimate (bool, optional): ...
            emoticon (Optional[str], optional): Emoji to use as icon for the folder.
        """

        self.title = title
        self.peers = peers
        self.chats = chats
        self.users = users
        self.title_noanimate = title_noanimate
        self.emoticon = emoticon

    def to_bytes(self, boxed: bool=True):
        with Writer(b'/\xce\x0e\xf1' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.title_noanimate, 1)
                writer.object(
                    self.title,
                    group_id=0X5D96896
                )

                if flags(self.emoticon, 0):
                    writer.string(self.emoticon)
                writer.vector(
                    self.peers,
                    lambda value: writer.object(
                        value,
                        group_id=0XB4DECBCA
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.object(
            group_id=0X5D96896
        )

        emoticon_ = (
            reader.string()
            if flags(0) else None
        )

        peers_ = reader.vector(
            lambda: reader.object(
                group_id=0XB4DECBCA
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            title=title_,
            peers=peers_,
            chats=chats_,
            users=users_,
            title_noanimate=flags(1),
            emoticon=emoticon_
        )

TypeChatlistsChatlistInvite = Union[
    ChatlistInviteAlready,
    ChatlistInvite
]