
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_media import TypeInputMedia
    from .input_reply_to import TypeInputReplyTo
    from .message_entity import TypeMessageEntity
    from .suggested_post import TypeSuggestedPost
    from ...gadgets.byteutils import Reader


class DraftMessageEmpty(TLObject, family='TypeDraftMessage'):
    """
    Empty draft
    """

    _id = 0X1B0C841A
    _group_id = 0X314F6157

    def __init__(
        self,
        date: Optional[int] = None
    ):

        """
        Empty draft

        Args:
            date (Optional[int], optional): When was the draft last updated
        """

        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1a\x84\x0c\x1b' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.date, 0):
                    writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        date_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            date=date_
        )

class DraftMessage(TLObject, family='TypeDraftMessage'):
    """
    Represents a message [draft](https://core.telegram.org/api/drafts).
    """

    _id = 0X96EAA5EB
    _group_id = 0X314F6157

    def __init__(
        self,
        message: str,
        date: int,
        no_webpage: bool = False,
        invert_media: bool = False,
        reply_to: Optional['TypeInputReplyTo'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        media: Optional['TypeInputMedia'] = None,
        effect: Optional[int] = None,
        suggested_post: Optional['TypeSuggestedPost'] = None
    ):

        """
        Represents a message [draft](https://core.telegram.org/api/drafts).

        Args:
            message (str): The draft
            date (int): Date of last update of the draft.
            no_webpage (bool, optional): Whether no webpage preview will be generated
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            reply_to (Optional['TypeInputReplyTo'], optional): If set, indicates that the message should be sent in reply to the specified message or story.
            entities (Optional[List['TypeMessageEntity']], optional): Message [entities](https://core.telegram.org/api/entities) for styled text.
            media (Optional['TypeInputMedia'], optional): Media.
            effect (Optional[int], optional): A [message effect that should be played as specified here](https://core.telegram.org/api/effects).
            suggested_post (Optional['TypeSuggestedPost'], optional): ...
        """

        self.message = message
        self.date = date
        self.no_webpage = no_webpage
        self.invert_media = invert_media
        self.reply_to = reply_to
        self.entities = entities
        self.media = media
        self.effect = effect
        self.suggested_post = suggested_post

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xeb\xa5\xea\x96' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.no_webpage, 1)
                flags(self.invert_media, 6)

                if flags(self.reply_to, 4):
                    writer.object(
                        self.reply_to,
                        group_id=0X8EEA0D0F
                    )
                writer.string(self.message)

                if flags(self.entities, 3):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.media, 5):
                    writer.object(
                        self.media,
                        group_id=0XCEC6DE21
                    )
                writer.int(self.date)

                if flags(self.effect, 7):
                    writer.long(self.effect)

                if flags(self.suggested_post, 8):
                    writer.object(
                        self.suggested_post,
                        group_id=0X7DC96856
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        reply_to_ = (
            reader.object(
                group_id=0X8EEA0D0F
            )
            if flags(4) else None
        )

        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(3) else None
        )

        media_ = (
            reader.object(
                group_id=0XCEC6DE21
            )
            if flags(5) else None
        )

        date_ = reader.int()
        effect_ = (
            reader.long()
            if flags(7) else None
        )

        suggested_post_ = (
            reader.object(
                group_id=0X7DC96856
            )
            if flags(8) else None
        )

        return cls(
            message=message_,
            date=date_,
            no_webpage=flags(1),
            invert_media=flags(6),
            reply_to=reply_to_,
            entities=entities_,
            media=media_,
            effect=effect_,
            suggested_post=suggested_post_
        )

TypeDraftMessage = Union[
    DraftMessageEmpty,
    DraftMessage
]