
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class EncryptedChatEmpty(TLObject, family='TypeEncryptedChat'):
    """
    Empty constructor.
    """

    _id = 0XAB7EC0A0
    _group_id = 0X9E93492C

    def __init__(
        self,
        id: int
    ):

        """
        Empty constructor.

        Args:
            id (int): Chat ID
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa0\xc0~\xab' if boxed else b'') as writer:
            writer.int(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()

        return cls(
            id=id_
        )

class EncryptedChatWaiting(TLObject, family='TypeEncryptedChat'):
    """
    Chat waiting for approval of second participant.
    """

    _id = 0X66B25953
    _group_id = 0X9E93492C

    def __init__(
        self,
        id: int,
        access_hash: int,
        date: int,
        admin_id: int,
        participant_id: int
    ):

        """
        Chat waiting for approval of second participant.

        Args:
            id (int): Chat ID
            access_hash (int): Checking sum depending on user ID
            date (int): Date of chat creation
            admin_id (int): Chat creator ID
            participant_id (int): ID of second chat participant
        """

        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'SY\xb2f' if boxed else b'') as writer:
            writer.int(self.id)
            writer.long(self.access_hash)
            writer.int(self.date)
            writer.long(self.admin_id)
            writer.long(self.participant_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()
        access_hash_ = reader.long()
        date_ = reader.int()
        admin_id_ = reader.long()
        participant_id_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_,
            date=date_,
            admin_id=admin_id_,
            participant_id=participant_id_
        )

class EncryptedChatRequested(TLObject, family='TypeEncryptedChat'):
    """
    Request to create an encrypted chat.
    """

    _id = 0X48F1D94C
    _group_id = 0X9E93492C

    def __init__(
        self,
        id: int,
        access_hash: int,
        date: int,
        admin_id: int,
        participant_id: int,
        g_a: bytes,
        folder_id: Optional[int] = None
    ):

        """
        Request to create an encrypted chat.

        Args:
            id (int): Chat ID
            access_hash (int): Check sum depending on user ID
            date (int): Chat creation date
            admin_id (int): Chat creator ID
            participant_id (int): ID of second chat participant
            g_a (bytes): A = g ^ a mod p, see [Wikipedia](https://en.wikipedia.org/wiki/Diffie%E2%80%93Hellman_key_exchange)
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
        """

        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a = g_a
        self.folder_id = folder_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'L\xd9\xf1H' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.folder_id, 0):
                    writer.int(self.folder_id)
                writer.int(self.id)
                writer.long(self.access_hash)
                writer.int(self.date)
                writer.long(self.admin_id)
                writer.long(self.participant_id)
                writer.bytes(self.g_a)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        folder_id_ = (
            reader.int()
            if flags(0) else None
        )

        id_ = reader.int()
        access_hash_ = reader.long()
        date_ = reader.int()
        admin_id_ = reader.long()
        participant_id_ = reader.long()
        g_a_ = reader.bytes()

        return cls(
            id=id_,
            access_hash=access_hash_,
            date=date_,
            admin_id=admin_id_,
            participant_id=participant_id_,
            g_a=g_a_,
            folder_id=folder_id_
        )

class EncryptedChat(TLObject, family='TypeEncryptedChat'):
    """
    Encrypted chat
    """

    _id = 0X61F0D4C7
    _group_id = 0X9E93492C

    def __init__(
        self,
        id: int,
        access_hash: int,
        date: int,
        admin_id: int,
        participant_id: int,
        g_a_or_b: bytes,
        key_fingerprint: int
    ):

        """
        Encrypted chat

        Args:
            id (int): Chat ID
            access_hash (int): Check sum dependent on the user ID
            date (int): Date chat was created
            admin_id (int): Chat creator ID
            participant_id (int): ID of the second chat participant
            g_a_or_b (bytes): B = g ^ b mod p, if the currently authorized user is the chat's creator, or A = g ^ a mod p otherwise See [Wikipedia](https://en.wikipedia.org/wiki/Diffie%E2%80%93Hellman_key_exchange) for more info
            key_fingerprint (int): 64-bit fingerprint of received key
        """

        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a_or_b = g_a_or_b
        self.key_fingerprint = key_fingerprint

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc7\xd4\xf0a' if boxed else b'') as writer:
            writer.int(self.id)
            writer.long(self.access_hash)
            writer.int(self.date)
            writer.long(self.admin_id)
            writer.long(self.participant_id)
            writer.bytes(self.g_a_or_b)
            writer.long(self.key_fingerprint)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()
        access_hash_ = reader.long()
        date_ = reader.int()
        admin_id_ = reader.long()
        participant_id_ = reader.long()
        g_a_or_b_ = reader.bytes()
        key_fingerprint_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_,
            date=date_,
            admin_id=admin_id_,
            participant_id=participant_id_,
            g_a_or_b=g_a_or_b_,
            key_fingerprint=key_fingerprint_
        )

class EncryptedChatDiscarded(TLObject, family='TypeEncryptedChat'):
    """
    Discarded or deleted chat.
    """

    _id = 0X1E1C7C45
    _group_id = 0X9E93492C

    def __init__(
        self,
        id: int,
        history_deleted: bool = False
    ):

        """
        Discarded or deleted chat.

        Args:
            id (int): Chat ID
            history_deleted (bool, optional): Whether both users of this secret chat should also remove all of its messages
        """

        self.id = id
        self.history_deleted = history_deleted

    def to_bytes(self, boxed: bool=True):
        with Writer(b'E|\x1c\x1e' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.history_deleted, 0)
                writer.int(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()

        return cls(
            id=id_,
            history_deleted=flags(0)
        )

TypeEncryptedChat = Union[
    EncryptedChatEmpty,
    EncryptedChatWaiting,
    EncryptedChatRequested,
    EncryptedChat,
    EncryptedChatDiscarded
]