
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .group_call_participant_video_source_group import TypeGroupCallParticipantVideoSourceGroup


class GroupCallParticipantVideo(TLObject, family='TypeGroupCallParticipantVideo'):
    """
    Info about a video stream
    """

    _id = 0X67753AC8
    _group_id = 0X20F73385

    def __init__(
        self,
        endpoint: str,
        source_groups: List['TypeGroupCallParticipantVideoSourceGroup'],
        paused: bool = False,
        audio_source: Optional[int] = None
    ):

        """
        Info about a video stream

        Args:
            endpoint (str): Endpoint
            source_groups (List['TypeGroupCallParticipantVideoSourceGroup']): Source groups
            paused (bool, optional): Whether the stream is currently paused
            audio_source (Optional[int], optional): Audio source ID
        """

        self.endpoint = endpoint
        self.source_groups = source_groups
        self.paused = paused
        self.audio_source = audio_source

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc8:ug' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.paused, 0)
                writer.string(self.endpoint)
                writer.vector(
                    self.source_groups,
                    lambda value: writer.object(
                        value,
                        group_id=0XF8A17DED
                    )
                )

                if flags(self.audio_source, 1):
                    writer.int(self.audio_source)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        endpoint_ = reader.string()
        source_groups_ = reader.vector(
            lambda: reader.object(
                group_id=0XF8A17DED
            )
        )

        audio_source_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            endpoint=endpoint_,
            source_groups=source_groups_,
            paused=flags(0),
            audio_source=audio_source_
        )

TypeGroupCallParticipantVideo = GroupCallParticipantVideo