
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_document import TypeInputDocument
    from ...gadgets.byteutils import Reader


class InputBusinessIntro(TLObject, family='TypeInputBusinessIntro'):
    """
    [Telegram Business introduction](https://core.telegram.org/api/business#business-introduction).
    """

    _id = 0X9C469CD
    _group_id = 0X9C514EC5

    def __init__(
        self,
        title: str,
        description: str,
        sticker: Optional['TypeInputDocument'] = None
    ):

        """
        [Telegram Business introduction](https://core.telegram.org/api/business#business-introduction).

        Args:
            title (str): Title of the introduction message
            description (str): Profile introduction
            sticker (Optional['TypeInputDocument'], optional): Optional introduction [sticker](https://core.telegram.org/api/stickers).
        """

        self.title = title
        self.description = description
        self.sticker = sticker

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcdi\xc4\t' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.sticker, 0):
                    writer.object(
                        self.sticker,
                        group_id=0X84313E
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.string()
        description_ = reader.string()
        sticker_ = (
            reader.object(
                group_id=0X84313E
            )
            if flags(0) else None
        )

        return cls(
            title=title_,
            description=description_,
            sticker=sticker_
        )

TypeInputBusinessIntro = InputBusinessIntro