
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_document import TypeInputDocument
    from ...gadgets.byteutils import Reader


class InputFile(TLObject, family='TypeInputFile'):
    """
    Defines a file saved in parts using the method [upload.saveFilePart](https://core.telegram.org/method/upload.saveFilePart).
    """

    _id = 0XF52FF27F
    _group_id = 0XB7247676

    def __init__(
        self,
        id: int,
        parts: int,
        name: str,
        md5_checksum: str
    ):

        """
        Defines a file saved in parts using the method [upload.saveFilePart](https://core.telegram.org/method/upload.saveFilePart).

        Args:
            id (int): Random file identifier created by the client
            parts (int): Number of parts saved
            name (str): Full name of the file
            md5_checksum (str): In case the file's [md5-hash](https://en.wikipedia.org/wiki/MD5#MD5_hashes) was passed, contents of the file will be checked prior to use
        """

        self.id = id
        self.parts = parts
        self.name = name
        self.md5_checksum = md5_checksum

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x7f\xf2/\xf5' if boxed else b'') as writer:
            writer.long(self.id)
            writer.int(self.parts)
            writer.string(self.name)
            writer.string(self.md5_checksum)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        parts_ = reader.int()
        name_ = reader.string()
        md5_checksum_ = reader.string()

        return cls(
            id=id_,
            parts=parts_,
            name=name_,
            md5_checksum=md5_checksum_
        )

class InputFileBig(TLObject, family='TypeInputFile'):
    """
    Assigns a big file (over 10 MB in size), saved in part using the method [upload.saveBigFilePart](https://core.telegram.org/method/upload.saveBigFilePart).
    """

    _id = 0XFA4F0BB5
    _group_id = 0XB7247676

    def __init__(
        self,
        id: int,
        parts: int,
        name: str
    ):

        """
        Assigns a big file (over 10 MB in size), saved in part using the method [upload.saveBigFilePart](https://core.telegram.org/method/upload.saveBigFilePart).

        Args:
            id (int): Random file id, created by the client
            parts (int): Number of parts saved
            name (str): Full file name
        """

        self.id = id
        self.parts = parts
        self.name = name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb5\x0bO\xfa' if boxed else b'') as writer:
            writer.long(self.id)
            writer.int(self.parts)
            writer.string(self.name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        parts_ = reader.int()
        name_ = reader.string()

        return cls(
            id=id_,
            parts=parts_,
            name=name_
        )

class InputFileStoryDocument(TLObject, family='TypeInputFile'):
    """
    Used to [edit the thumbnail/static preview of a story, see here](https://core.telegram.org/api/stories#editing-stories) for more info on the full flow.
    """

    _id = 0X62DC8B48
    _group_id = 0XB7247676

    def __init__(
        self,
        id: 'TypeInputDocument'
    ):

        """
        Used to [edit the thumbnail/static preview of a story, see here](https://core.telegram.org/api/stories#editing-stories) for more info on the full flow.

        Args:
            id ('TypeInputDocument'): The old story video.
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'H\x8b\xdcb' if boxed else b'') as writer:
            writer.object(
                self.id,
                group_id=0X84313E
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.object(
            group_id=0X84313E
        )

        return cls(
            id=id_
        )

TypeInputFile = Union[
    InputFile,
    InputFileBig,
    InputFileStoryDocument
]