
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class InputGeoPointEmpty(TLObject, family='TypeInputGeoPoint'):
    """
    Empty GeoPoint constructor.
    """

    _id = 0XE4C123D6
    _group_id = 0XF78B3873


    def to_bytes(self, boxed: bool=True):
        return b'\xd6#\xc1\xe4' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputGeoPoint(TLObject, family='TypeInputGeoPoint'):
    """
    Defines a GeoPoint by its coordinates.
    """

    _id = 0X48222FAF
    _group_id = 0XF78B3873

    def __init__(
        self,
        lat: float,
        long: float,
        accuracy_radius: Optional[int] = None
    ):

        """
        Defines a GeoPoint by its coordinates.

        Args:
            lat (float): Latitude
            long (float): Longitude
            accuracy_radius (Optional[int], optional): The estimated horizontal accuracy of the location, in meters; as defined by the sender.
        """

        self.lat = lat
        self.long = long
        self.accuracy_radius = accuracy_radius

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xaf/"H' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.double(self.lat)
                writer.double(self.long)

                if flags(self.accuracy_radius, 0):
                    writer.int(self.accuracy_radius)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        lat_ = reader.double()
        long_ = reader.double()
        accuracy_radius_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            lat=lat_,
            long=long_,
            accuracy_radius=accuracy_radius_
        )

TypeInputGeoPoint = Union[
    InputGeoPointEmpty,
    InputGeoPoint
]