
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .data_json import TypeDataJSON
    from ...gadgets.byteutils import Reader


class InputPaymentCredentialsSaved(TLObject, family='TypeInputPaymentCredentials'):
    """
    Saved payment credentials
    """

    _id = 0XC10EB2CF
    _group_id = 0XED81B2F2

    def __init__(
        self,
        id: str,
        tmp_password: bytes
    ):

        """
        Saved payment credentials

        Args:
            id (str): Credential ID
            tmp_password (bytes): Temporary password
        """

        self.id = id
        self.tmp_password = tmp_password

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcf\xb2\x0e\xc1' if boxed else b'') as writer:
            writer.string(self.id)
            writer.bytes(self.tmp_password)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.string()
        tmp_password_ = reader.bytes()

        return cls(
            id=id_,
            tmp_password=tmp_password_
        )

class InputPaymentCredentials(TLObject, family='TypeInputPaymentCredentials'):
    """
    Payment credentials
    """

    _id = 0X3417D728
    _group_id = 0XED81B2F2

    def __init__(
        self,
        data: 'TypeDataJSON',
        save: bool = False
    ):

        """
        Payment credentials

        Args:
            data ('TypeDataJSON'): Payment credentials
            save (bool, optional): Save payment credential for future use
        """

        self.data = data
        self.save = save

    def to_bytes(self, boxed: bool=True):
        with Writer(b'(\xd7\x174' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.save, 0)
                writer.object(
                    self.data,
                    group_id=0XE95B0798
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        data_ = reader.object(
            group_id=0XE95B0798
        )

        return cls(
            data=data_,
            save=flags(0)
        )

class InputPaymentCredentialsApplePay(TLObject, family='TypeInputPaymentCredentials'):
    """
    Apple pay payment credentials
    """

    _id = 0XAA1C39F
    _group_id = 0XED81B2F2

    def __init__(
        self,
        payment_data: 'TypeDataJSON'
    ):

        """
        Apple pay payment credentials

        Args:
            payment_data ('TypeDataJSON'): Payment data
        """

        self.payment_data = payment_data

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9f\xc3\xa1\n' if boxed else b'') as writer:
            writer.object(
                self.payment_data,
                group_id=0XE95B0798
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        payment_data_ = reader.object(
            group_id=0XE95B0798
        )

        return cls(
            payment_data=payment_data_
        )

class InputPaymentCredentialsGooglePay(TLObject, family='TypeInputPaymentCredentials'):
    """
    Google Pay payment credentials
    """

    _id = 0X8AC32801
    _group_id = 0XED81B2F2

    def __init__(
        self,
        payment_token: 'TypeDataJSON'
    ):

        """
        Google Pay payment credentials

        Args:
            payment_token ('TypeDataJSON'): Payment token
        """

        self.payment_token = payment_token

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x01(\xc3\x8a' if boxed else b'') as writer:
            writer.object(
                self.payment_token,
                group_id=0XE95B0798
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        payment_token_ = reader.object(
            group_id=0XE95B0798
        )

        return cls(
            payment_token=payment_token_
        )

TypeInputPaymentCredentials = Union[
    InputPaymentCredentialsSaved,
    InputPaymentCredentials,
    InputPaymentCredentialsApplePay,
    InputPaymentCredentialsGooglePay
]