
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..document import TypeDocument
    from ....gadgets.byteutils import Reader


class FoundStickersNotModified(TLObject, family='TypeMessagesFoundStickers'):
    """
    No new stickers were found for the specified query
    """

    _id = 0X6010C534
    _group_id = 0X3F23B008

    def __init__(
        self,
        next_offset: Optional[int] = None
    ):

        """
        No new stickers were found for the specified query

        Args:
            next_offset (Optional[int], optional): Offset for [pagination](https://core.telegram.org/api/offsets)
        """

        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'4\xc5\x10`' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.next_offset, 0):
                    writer.int(self.next_offset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        next_offset_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            next_offset=next_offset_
        )

class FoundStickers(TLObject, family='TypeMessagesFoundStickers'):
    """
    Found stickers
    """

    _id = 0X82C9E290
    _group_id = 0X3F23B008

    def __init__(
        self,
        hash: int,
        stickers: List['TypeDocument'],
        next_offset: Optional[int] = None
    ):

        """
        Found stickers

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            stickers (List['TypeDocument']): Found stickers
            next_offset (Optional[int], optional): Offset for [pagination](https://core.telegram.org/api/offsets)
        """

        self.hash = hash
        self.stickers = stickers
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x90\xe2\xc9\x82' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.next_offset, 0):
                    writer.int(self.next_offset)
                writer.long(self.hash)
                writer.vector(
                    self.stickers,
                    lambda value: writer.object(
                        value,
                        group_id=0X6547BD50
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        next_offset_ = (
            reader.int()
            if flags(0) else None
        )

        hash_ = reader.long()
        stickers_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        return cls(
            hash=hash_,
            stickers=stickers_,
            next_offset=next_offset_
        )

TypeMessagesFoundStickers = Union[
    FoundStickersNotModified,
    FoundStickers
]