
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo import TypePhoto
    from .document import TypeDocument
    from .page_block import TypePageBlock
    from ...gadgets.byteutils import Reader


class Page(TLObject, family='TypePage'):
    """
    [Instant view](https://instantview.telegram.org) page
    """

    _id = 0X98657F0D
    _group_id = 0X2328453

    def __init__(
        self,
        url: str,
        blocks: List['TypePageBlock'],
        photos: List['TypePhoto'],
        documents: List['TypeDocument'],
        part: bool = False,
        rtl: bool = False,
        v2: bool = False,
        views: Optional[int] = None
    ):

        """
        [Instant view](https://instantview.telegram.org) page

        Args:
            url (str): Original page HTTP URL
            blocks (List['TypePageBlock']): Page elements (like with HTML elements, only as TL constructors)
            photos (List['TypePhoto']): Photos in page
            documents (List['TypeDocument']): Media in page
            part (bool, optional): Indicates that not full page preview is available to the client and it will need to fetch full Instant View from the server using [messages.getWebPagePreview](https://core.telegram.org/method/messages.getWebPagePreview).
            rtl (bool, optional): Whether the page contains RTL text
            v2 (bool, optional): Whether this is an [IV v2](https://instantview.telegram.org/docs#what-39s-new-in-2-0) page
            views (Optional[int], optional): View count
        """

        self.url = url
        self.blocks = blocks
        self.photos = photos
        self.documents = documents
        self.part = part
        self.rtl = rtl
        self.v2 = v2
        self.views = views

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\r\x7fe\x98' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.part, 0)
                flags(self.rtl, 1)
                flags(self.v2, 2)
                writer.string(self.url)
                writer.vector(
                    self.blocks,
                    lambda value: writer.object(
                        value,
                        group_id=0X4A8B7F2D
                    )
                )
                writer.vector(
                    self.photos,
                    lambda value: writer.object(
                        value,
                        group_id=0XDDAD9CAC
                    )
                )
                writer.vector(
                    self.documents,
                    lambda value: writer.object(
                        value,
                        group_id=0X6547BD50
                    )
                )

                if flags(self.views, 3):
                    writer.int(self.views)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        url_ = reader.string()
        blocks_ = reader.vector(
            lambda: reader.object(
                group_id=0X4A8B7F2D
            )
        )

        photos_ = reader.vector(
            lambda: reader.object(
                group_id=0XDDAD9CAC
            )
        )

        documents_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        views_ = (
            reader.int()
            if flags(3) else None
        )

        return cls(
            url=url_,
            blocks=blocks_,
            photos=photos_,
            documents=documents_,
            part=flags(0),
            rtl=flags(1),
            v2=flags(2),
            views=views_
        )

TypePage = Page