
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PasswordKdfAlgoUnknown(TLObject, family='TypePasswordKdfAlgo'):
    """
    Unknown KDF (most likely, the client is outdated and does not support the specified KDF algorithm)
    """

    _id = 0XD45AB096
    _group_id = 0X9B82F7C3


    def to_bytes(self, boxed: bool=True):
        return b'\x96\xb0Z\xd4' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(TLObject, family='TypePasswordKdfAlgo'):
    """
    This key derivation algorithm defines that [SRP 2FA login](https://core.telegram.org/api/srp) must be used
    """

    _id = 0X3A912D4A
    _group_id = 0X9B82F7C3

    def __init__(
        self,
        salt1: bytes,
        salt2: bytes,
        g: int,
        p: bytes
    ):

        """
        This key derivation algorithm defines that [SRP 2FA login](https://core.telegram.org/api/srp) must be used

        Args:
            salt1 (bytes): One of two salts used by the derivation function (see [SRP 2FA login](https://core.telegram.org/api/srp))
            salt2 (bytes): One of two salts used by the derivation function (see [SRP 2FA login](https://core.telegram.org/api/srp))
            g (int): Base (see [SRP 2FA login](https://core.telegram.org/api/srp))
            p (bytes): 2048-bit modulus (see [SRP 2FA login](https://core.telegram.org/api/srp))
        """

        self.salt1 = salt1
        self.salt2 = salt2
        self.g = g
        self.p = p

    def to_bytes(self, boxed: bool=True):
        with Writer(b'J-\x91:' if boxed else b'') as writer:
            writer.bytes(self.salt1)
            writer.bytes(self.salt2)
            writer.int(self.g)
            writer.bytes(self.p)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        salt1_ = reader.bytes()
        salt2_ = reader.bytes()
        g_ = reader.int()
        p_ = reader.bytes()

        return cls(
            salt1=salt1_,
            salt2=salt2_,
            g=g_,
            p=p_
        )

TypePasswordKdfAlgo = Union[
    PasswordKdfAlgoUnknown,
    PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow
]