
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class GiveawayInfo(TLObject, family='TypePaymentsGiveawayInfo'):
    """
    Contains info about an ongoing [giveaway](https://core.telegram.org/api/giveaways).
    """

    _id = 0X4367DAA0
    _group_id = 0XE0D92117

    def __init__(
        self,
        start_date: int,
        participating: bool = False,
        preparing_results: bool = False,
        joined_too_early_date: Optional[int] = None,
        admin_disallowed_chat_id: Optional[int] = None,
        disallowed_country: Optional[str] = None
    ):

        """
        Contains info about an ongoing [giveaway](https://core.telegram.org/api/giveaways).

        Args:
            start_date (int): When was the giveaway started
            participating (bool, optional): The current user is participating in the giveaway.
            preparing_results (bool, optional): If set, the giveaway has ended and the results are being prepared.
            joined_too_early_date (Optional[int], optional): The current user can't participate in the giveaway, because they were already a member of the channel when the giveaway started, and the only_new_subscribers was set when starting the giveaway.
            admin_disallowed_chat_id (Optional[int], optional): If set, the current user can't participate in the giveaway, because they are an administrator in one of the channels (ID specified in this flag) that created the giveaway.
            disallowed_country (Optional[str], optional): If set, the current user can't participate in this giveaway, because their phone number is from the specified disallowed country (specified as a two-letter ISO 3166-1 alpha-2 country code).
        """

        self.start_date = start_date
        self.participating = participating
        self.preparing_results = preparing_results
        self.joined_too_early_date = joined_too_early_date
        self.admin_disallowed_chat_id = admin_disallowed_chat_id
        self.disallowed_country = disallowed_country

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa0\xdagC' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.participating, 0)
                flags(self.preparing_results, 3)
                writer.int(self.start_date)

                if flags(self.joined_too_early_date, 1):
                    writer.int(self.joined_too_early_date)

                if flags(self.admin_disallowed_chat_id, 2):
                    writer.long(self.admin_disallowed_chat_id)

                if flags(self.disallowed_country, 4):
                    writer.string(self.disallowed_country)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        start_date_ = reader.int()
        joined_too_early_date_ = (
            reader.int()
            if flags(1) else None
        )

        admin_disallowed_chat_id_ = (
            reader.long()
            if flags(2) else None
        )

        disallowed_country_ = (
            reader.string()
            if flags(4) else None
        )

        return cls(
            start_date=start_date_,
            participating=flags(0),
            preparing_results=flags(3),
            joined_too_early_date=joined_too_early_date_,
            admin_disallowed_chat_id=admin_disallowed_chat_id_,
            disallowed_country=disallowed_country_
        )

class GiveawayInfoResults(TLObject, family='TypePaymentsGiveawayInfo'):
    """
    A [giveaway](https://core.telegram.org/api/giveaways) has ended.
    """

    _id = 0XE175E66F
    _group_id = 0XE0D92117

    def __init__(
        self,
        start_date: int,
        finish_date: int,
        winners_count: int,
        winner: bool = False,
        refunded: bool = False,
        gift_code_slug: Optional[str] = None,
        stars_prize: Optional[int] = None,
        activated_count: Optional[int] = None
    ):

        """
        A [giveaway](https://core.telegram.org/api/giveaways) has ended.

        Args:
            start_date (int): Start date of the giveaway
            finish_date (int): End date of the giveaway. May be bigger than the end date specified in parameters of the giveaway.
            winners_count (int): Number of winners in the giveaway
            winner (bool, optional): Whether we're one of the winners of this giveaway.
            refunded (bool, optional): Whether the giveaway was canceled and was fully refunded.
            gift_code_slug (Optional[str], optional): If we're one of the winners of this giveaway, contains the [Premium gift code](https://core.telegram.org/api/links#premium-giftcode-links), see [here](https://core.telegram.org/api/giveaways) for more info on the full giveaway flow.
            stars_prize (Optional[int], optional): If we're one of the winners of this [Telegram Star giveaway](https://core.telegram.org/api/giveaways#star-giveaways), the number [Telegram Stars](https://core.telegram.org/api/stars) we won.
            activated_count (Optional[int], optional): Number of winners, which activated their [gift codes](https://core.telegram.org/api/links#premium-giftcode-links).
        """

        self.start_date = start_date
        self.finish_date = finish_date
        self.winners_count = winners_count
        self.winner = winner
        self.refunded = refunded
        self.gift_code_slug = gift_code_slug
        self.stars_prize = stars_prize
        self.activated_count = activated_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'o\xe6u\xe1' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.winner, 0)
                flags(self.refunded, 1)
                writer.int(self.start_date)

                if flags(self.gift_code_slug, 3):
                    writer.string(self.gift_code_slug)

                if flags(self.stars_prize, 4):
                    writer.long(self.stars_prize)
                writer.int(self.finish_date)
                writer.int(self.winners_count)

                if flags(self.activated_count, 2):
                    writer.int(self.activated_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        start_date_ = reader.int()
        gift_code_slug_ = (
            reader.string()
            if flags(3) else None
        )

        stars_prize_ = (
            reader.long()
            if flags(4) else None
        )

        finish_date_ = reader.int()
        winners_count_ = reader.int()
        activated_count_ = (
            reader.int()
            if flags(2) else None
        )

        return cls(
            start_date=start_date_,
            finish_date=finish_date_,
            winners_count=winners_count_,
            winner=flags(0),
            refunded=flags(1),
            gift_code_slug=gift_code_slug_,
            stars_prize=stars_prize_,
            activated_count=activated_count_
        )

TypePaymentsGiveawayInfo = Union[
    GiveawayInfo,
    GiveawayInfoResults
]