
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PremiumGiftCodeOption(TLObject, family='TypePremiumGiftCodeOption'):
    """
    Contains info about a [giveaway/gift](https://core.telegram.org/api/giveaways) option.
    """

    _id = 0X257E962B
    _group_id = 0X4B2119E1

    def __init__(
        self,
        users: int,
        months: int,
        currency: str,
        amount: int,
        store_product: Optional[str] = None,
        store_quantity: Optional[int] = None
    ):

        """
        Contains info about a [giveaway/gift](https://core.telegram.org/api/giveaways) option.

        Args:
            users (int): Number of users which will be able to activate the gift codes.
            months (int): Duration in months of each gifted [Telegram Premium](https://core.telegram.org/api/premium) subscription.
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            store_product (Optional[str], optional): Identifier of the store product associated with the option, official apps only.
            store_quantity (Optional[int], optional): Number of times the store product must be paid
        """

        self.users = users
        self.months = months
        self.currency = currency
        self.amount = amount
        self.store_product = store_product
        self.store_quantity = store_quantity

    def to_bytes(self, boxed: bool=True):
        with Writer(b'+\x96~%' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.users)
                writer.int(self.months)

                if flags(self.store_product, 0):
                    writer.string(self.store_product)

                if flags(self.store_quantity, 1):
                    writer.int(self.store_quantity)
                writer.string(self.currency)
                writer.long(self.amount)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        users_ = reader.int()
        months_ = reader.int()
        store_product_ = (
            reader.string()
            if flags(0) else None
        )

        store_quantity_ = (
            reader.int()
            if flags(1) else None
        )

        currency_ = reader.string()
        amount_ = reader.long()

        return cls(
            users=users_,
            months=months_,
            currency=currency_,
            amount=amount_,
            store_product=store_product_,
            store_quantity=store_quantity_
        )

TypePremiumGiftCodeOption = PremiumGiftCodeOption