
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class SendAsPeer(TLObject, family='TypeSendAsPeer'):
    """
    Indicates a peer that can be used to send messages
    """

    _id = 0XB81C7034
    _group_id = 0X701D1931

    def __init__(
        self,
        peer: 'TypePeer',
        premium_required: bool = False
    ):

        """
        Indicates a peer that can be used to send messages

        Args:
            peer ('TypePeer'): Peer
            premium_required (bool, optional): Whether a Telegram Premium account is required to send messages as this peer
        """

        self.peer = peer
        self.premium_required = premium_required

    def to_bytes(self, boxed: bool=True):
        with Writer(b'4p\x1c\xb8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.premium_required, 0)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        return cls(
            peer=peer_,
            premium_required=flags(0)
        )

TypeSendAsPeer = SendAsPeer