
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .message import TypeMessage
    from .reaction import TypeReaction
    from .story_item import TypeStoryItem
    from ...gadgets.byteutils import Reader


class StoryReaction(TLObject, family='TypeStoryReaction'):
    """
    How a certain peer reacted to a story
    """

    _id = 0X6090D6D5
    _group_id = 0X3AD0B5FD

    def __init__(
        self,
        peer_id: 'TypePeer',
        date: int,
        reaction: 'TypeReaction'
    ):

        """
        How a certain peer reacted to a story

        Args:
            peer_id ('TypePeer'): The peer
            date (int): Reaction date
            reaction ('TypeReaction'): The reaction
        """

        self.peer_id = peer_id
        self.date = date
        self.reaction = reaction

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd5\xd6\x90`' if boxed else b'') as writer:
            writer.object(
                self.peer_id,
                group_id=0XB4DECBCA
            )
            writer.int(self.date)
            writer.object(
                self.reaction,
                group_id=0X19F930D1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        date_ = reader.int()
        reaction_ = reader.object(
            group_id=0X19F930D1
        )

        return cls(
            peer_id=peer_id_,
            date=date_,
            reaction=reaction_
        )

class StoryReactionPublicForward(TLObject, family='TypeStoryReaction'):
    """
    A certain peer has forwarded the story as a message to a public chat or channel.
    """

    _id = 0XBBAB2643
    _group_id = 0X3AD0B5FD

    def __init__(
        self,
        message: 'TypeMessage'
    ):

        """
        A certain peer has forwarded the story as a message to a public chat or channel.

        Args:
            message ('TypeMessage'): The message with the forwarded story.
        """

        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'C&\xab\xbb' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        return cls(
            message=message_
        )

class StoryReactionPublicRepost(TLObject, family='TypeStoryReaction'):
    """
    A certain peer has reposted the story.
    """

    _id = 0XCFCD0F13
    _group_id = 0X3AD0B5FD

    def __init__(
        self,
        peer_id: 'TypePeer',
        story: 'TypeStoryItem'
    ):

        """
        A certain peer has reposted the story.

        Args:
            peer_id ('TypePeer'): The peer that reposted the story.
            story ('TypeStoryItem'): The reposted story.
        """

        self.peer_id = peer_id
        self.story = story

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x13\x0f\xcd\xcf' if boxed else b'') as writer:
            writer.object(
                self.peer_id,
                group_id=0XB4DECBCA
            )
            writer.object(
                self.story,
                group_id=0X8436985A
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        story_ = reader.object(
            group_id=0X8436985A
        )

        return cls(
            peer_id=peer_id_,
            story=story_
        )

TypeStoryReaction = Union[
    StoryReaction,
    StoryReactionPublicForward,
    StoryReactionPublicRepost
]