
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .message import TypeMessage
    from .reaction import TypeReaction
    from .story_item import TypeStoryItem
    from ...gadgets.byteutils import Reader


class StoryView(TLObject, family='TypeStoryView'):
    """
    [Story](https://core.telegram.org/api/stories) view date and reaction information
    """

    _id = 0XB0BDEAC5
    _group_id = 0X65D016CA

    def __init__(
        self,
        user_id: int,
        date: int,
        blocked: bool = False,
        blocked_my_stories_from: bool = False,
        reaction: Optional['TypeReaction'] = None
    ):

        """
        [Story](https://core.telegram.org/api/stories) view date and reaction information

        Args:
            user_id (int): The user that viewed the story
            date (int): When did the user view the story
            blocked (bool, optional): Whether we have [completely blocked](https://core.telegram.org/api/block) this user, including from viewing more of our stories.
            blocked_my_stories_from (bool, optional): Whether we have [blocked](https://core.telegram.org/api/block) this user from viewing more of our stories.
            reaction (Optional['TypeReaction'], optional): If present, contains the reaction that the user left on the story
        """

        self.user_id = user_id
        self.date = date
        self.blocked = blocked
        self.blocked_my_stories_from = blocked_my_stories_from
        self.reaction = reaction

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc5\xea\xbd\xb0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.blocked, 0)
                flags(self.blocked_my_stories_from, 1)
                writer.long(self.user_id)
                writer.int(self.date)

                if flags(self.reaction, 2):
                    writer.object(
                        self.reaction,
                        group_id=0X19F930D1
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.long()
        date_ = reader.int()
        reaction_ = (
            reader.object(
                group_id=0X19F930D1
            )
            if flags(2) else None
        )

        return cls(
            user_id=user_id_,
            date=date_,
            blocked=flags(0),
            blocked_my_stories_from=flags(1),
            reaction=reaction_
        )

class StoryViewPublicForward(TLObject, family='TypeStoryView'):
    """
    A certain peer has forwarded the story as a message to a public chat or channel.
    """

    _id = 0X9083670B
    _group_id = 0X65D016CA

    def __init__(
        self,
        message: 'TypeMessage',
        blocked: bool = False,
        blocked_my_stories_from: bool = False
    ):

        """
        A certain peer has forwarded the story as a message to a public chat or channel.

        Args:
            message ('TypeMessage'): The message with the forwarded story.
            blocked (bool, optional): Whether we have [completely blocked](https://core.telegram.org/api/block) this user, including from viewing more of our stories.
            blocked_my_stories_from (bool, optional): Whether we have [blocked](https://core.telegram.org/api/block) this user from viewing more of our stories.
        """

        self.message = message
        self.blocked = blocked
        self.blocked_my_stories_from = blocked_my_stories_from

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0bg\x83\x90' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.blocked, 0)
                flags(self.blocked_my_stories_from, 1)
                writer.object(
                    self.message,
                    group_id=0X25780A8F
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        message_ = reader.object(
            group_id=0X25780A8F
        )

        return cls(
            message=message_,
            blocked=flags(0),
            blocked_my_stories_from=flags(1)
        )

class StoryViewPublicRepost(TLObject, family='TypeStoryView'):
    """
    A certain peer has reposted the story.
    """

    _id = 0XBD74CF49
    _group_id = 0X65D016CA

    def __init__(
        self,
        peer_id: 'TypePeer',
        story: 'TypeStoryItem',
        blocked: bool = False,
        blocked_my_stories_from: bool = False
    ):

        """
        A certain peer has reposted the story.

        Args:
            peer_id ('TypePeer'): The peer that reposted the story.
            story ('TypeStoryItem'): The reposted story.
            blocked (bool, optional): Whether we have [completely blocked](https://core.telegram.org/api/block) this user, including from viewing more of our stories.
            blocked_my_stories_from (bool, optional): Whether we have [blocked](https://core.telegram.org/api/block) this user from viewing more of our stories.
        """

        self.peer_id = peer_id
        self.story = story
        self.blocked = blocked
        self.blocked_my_stories_from = blocked_my_stories_from

    def to_bytes(self, boxed: bool=True):
        with Writer(b'I\xcft\xbd' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.blocked, 0)
                flags(self.blocked_my_stories_from, 1)
                writer.object(
                    self.peer_id,
                    group_id=0XB4DECBCA
                )
                writer.object(
                    self.story,
                    group_id=0X8436985A
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        story_ = reader.object(
            group_id=0X8436985A
        )

        return cls(
            peer_id=peer_id_,
            story=story_,
            blocked=flags(0),
            blocked_my_stories_from=flags(1)
        )

TypeStoryView = Union[
    StoryView,
    StoryViewPublicForward,
    StoryViewPublicRepost
]